package com.vsi.xmlf.beans;

import com.vsi.xmlf.Recipient;
import com.vsi.xmlf.Sender;
import com.vsi.xmlf.FaxNumber;
import com.vsi.xmlf.VoiceNumber;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

import java.awt.Dimension;
import java.awt.Color;
import java.awt.Font;


public
class PersonForm extends JPanel 
	implements DocumentListener, java.io.Serializable {

	public static final String NAME         = "Name";
	public static final String COMPANY      = "Company";
	public static final String FAX_NUMBER   = "FaxNumber";
	public static final String VOICE_NUMBER = "VoiceNumber";

	protected static final String COMPONENT = "Component";

	LabeledPairLayout _layout = null;

	protected JTextField _name         = null;
	protected JTextField _company      = null;
	protected JTextField _fax_number   = null;
	protected JTextField _voice_number = null;

	protected String _name_value       = "";
	protected String _company_value    = "";
	protected String _fax_value        = "";
	protected String _voice_value      = "";

	protected Font _text_font = new Font("Dialog", Font.PLAIN, 12);

	protected static Class _set_classes[] = new Class[1];
	static {
	    try {
		_set_classes[0] = Class.forName("javax.swing.JLabel");
	    } catch (Exception e) {
	    }
	}


	/**
	 *
	 */
	public PersonForm () {

		Document doc;

		_layout = new LabeledPairLayout();
		setLayout(_layout);

		JLabel l = new JLabel("Name: ", JLabel.RIGHT);
		_name = new JTextField(_name_value, 25);
		doc = _name.getDocument();
		doc.putProperty(COMPONENT, _name);
		doc.addDocumentListener(this);
		l.setLabelFor(_name);
		l.setDisplayedMnemonic('N');
		add(l, "label");
		add(_name, "field");

		l = new JLabel("Company: ", JLabel.RIGHT);
		_company = new JTextField(_company_value, 25);
		_company.setFont(_text_font);
		doc = _company.getDocument();
		doc.putProperty(COMPONENT, _company);
		doc.addDocumentListener(this);
		l.setLabelFor(_company);
		l.setDisplayedMnemonic('C');
		add(l, "label");
		add(_company, "field");


		l = new JLabel("Fax Number: ", JLabel.RIGHT);
		_fax_number = new JTextField(_fax_value, 25);
		_fax_number.setFont(_text_font);
		doc = _fax_number.getDocument();
		doc.putProperty(COMPONENT, _fax_number);
		doc.addDocumentListener(this);
		l.setLabelFor(_fax_number);
		l.setDisplayedMnemonic('F');
		add(l, "label");
		add(_fax_number, "field");


		l = new JLabel("Voice Number: ", JLabel.RIGHT);
		_voice_number = new JTextField(_voice_value, 25);
		_voice_number.setFont(_text_font);
		doc = _voice_number.getDocument();
		doc.putProperty(COMPONENT, _voice_number);
		doc.addDocumentListener(this);
		l.setLabelFor(_voice_number);
		l.setDisplayedMnemonic('V');
		add(l, "label");
		add(_voice_number, "field");

		setFont(getFont());
		setBackground(getBackground());
		setForeground(getForeground());
	}


	public Dimension getMinimumSize () {
		return (_layout.minimumLayoutSize(this));
	}


	public Dimension getPreferredSize () {
		return (_layout.preferredLayoutSize(this));
	}



	public void setBackground (Color c) {
		super.setBackground(c);
		GuiUtils.setChildrenBackground(this, _set_classes, c);
	}


	public void setForeground (Color c) {
		super.setForeground(c);
		GuiUtils.setChildrenForeground(this, _set_classes, c);
	}


	public Font getTextFont () {
		return (_text_font);
	}



	public void setTextFont (Font f) {

		_text_font = f;

		if (_name == null) {
			return;
		}

		_name.setFont(f);
		_company.setFont(f);
		_fax_number.setFont(f);
		_voice_number.setFont(f);
	}


	public void setFont (Font f) {
		super.setFont(f);
		GuiUtils.setChildrenFont(this, _set_classes, f);
		revalidate();
	}


	public synchronized void clear () {
		setPersonalName(null);
		setCompanyName(null);
		setFaxNumber(null);
		setVoiceNumber(null);
	}


	public synchronized Recipient getRecipient () {

		return (new Recipient(getPersonalName(), getCompanyName(),
			new FaxNumber(getFaxNumber()),
			new VoiceNumber(getVoiceNumber())));
	}


	public synchronized boolean isValidRecipient () {

		String fn = getFaxNumber();
		return (fn != null && fn.length() > 0);
	}


	public synchronized boolean isValidSender () {

		String n = getPersonalName();
		return (n != null && n.length() > 0);
	}


	public synchronized Sender getSender () {

		return (new Sender(getPersonalName(), getCompanyName(),
			new FaxNumber(getFaxNumber()),
			new VoiceNumber(getVoiceNumber())));
	}


	/**
	 * Returns the value of the "Name" field.
	 *
	 */
	public synchronized String getPersonalName () {
		_name_value = _name.getText();
		return (_name_value);
	}


	/**
	 * Sets the value for the "Name" field. If name is null
	 * or empty, has the effect of simply clearing the value.
	 *
	 * @param  name  the new name to be set.
	 */
	public synchronized void setPersonalName (String name) {
		firePropertyChange(NAME, _name_value, name);
		_name_value = name;
		_name.setText(name);
	}


	/**
	 * Returns the value of the "Company" field.
	 *
	 */
	public synchronized String getCompanyName () {
		
		_company_value = _company.getText();
		return (_company_value);
	}


	/**
	 * Sets the value for the "Company" field. If company is null
	 * or empty, has the effect of simply clearing the value.
	 *
	 * @param  company  the new company to be set.
	 */
	public synchronized void setCompanyName (String company) {
		firePropertyChange(COMPANY, _company_value, company);
		_company_value = company;
		_company.setText(company);
	}


	/**
	 * Returns the value of the "Fax Number" field.
	 */
	public synchronized String getFaxNumber () {
		_fax_value = _fax_number.getText();
		return (_fax_value);
	}


	/**
	 * Sets the value for the "Fax Number" field. If fax_number is
	 * null or empty, has the effect of simply clearing the old fax number.
	 *
	 * @param  fax_number  the new fax number to be set.
	 */
	public synchronized void setFaxNumber (String fax_number) {
		firePropertyChange(FAX_NUMBER, _fax_value, fax_number);
		_fax_value = fax_number;
		_fax_number.setText(fax_number);
	}


	/**
	 * Returns the value of the "Voice Number" field.
	 */
	public synchronized String getVoiceNumber () {
		_voice_value = _voice_number.getText();
		return (_voice_value);
	}


	/**
	 * Sets the value for the "Voice Number" field. If voice_number
	 * is null or empty, has the effect of simply clearing the old value.
	 *
	 * @param  voice_number  the new voice number to be set.
	 */
	public synchronized void setVoiceNumber (String voice_number) {
		firePropertyChange(VOICE_NUMBER, _voice_value, voice_number);
		_voice_value = voice_number;
		_voice_number.setText(voice_number);
	}


	public void changedUpdate (DocumentEvent e) {
	}


	public void removeUpdate (DocumentEvent e) {
		insertUpdate(e);
	}


	public void insertUpdate (DocumentEvent e) {
	
		Document doc = e.getDocument();
		JTextField source = (JTextField)doc.getProperty(COMPONENT);

		if (source == _name) {
			String old_value = _name_value;
			_name_value = source.getText();

			if (old_value == null && _name_value == null) {
				return;
			} 

			if (old_value == null || _name_value == null ||
				old_value.equals(_name_value)) {
					return;
			}

			firePropertyChange(NAME, old_value, _name_value);

		} else if (source == _company) {
			String old_value = _company_value;
			_company_value = source.getText();

			if (old_value == null && _company_value == null) {
				return;
			} 

			if (old_value == null || _company_value == null ||
				old_value.equals(_company_value)) {
					return;
			}

			firePropertyChange(
				COMPANY, old_value, _company_value);
		} else if (source == _fax_number) {
			String old_value = _fax_value;
			_fax_value = source.getText();

			if (old_value == null && _fax_value == null) {
				return;
			} 

			if (old_value == null || _fax_value == null ||
				old_value.equals(_fax_value)) {
					return;
			}

			firePropertyChange(FAX_NUMBER, old_value, _fax_value);
		} else if (source == _voice_number) {
			String old_value = _voice_value;
			_voice_value = source.getText();

			if (old_value == null && _voice_value == null) {
				return;
			} 

			if (old_value == null || _voice_value == null ||
				old_value.equals(_voice_value)) {
					return;
			}

			firePropertyChange(
				VOICE_NUMBER, old_value, _voice_value);
		}
	}
}
