package com.vsi.xmlf.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;

/**
 *
 *
 */
public class GuiUtils implements java.io.Serializable {

	public final static Dimension SPACER_08  = new Dimension(8, 8);
	public final static Dimension SPACER_16  = new Dimension(16, 16);
	public final static Dimension SPACER_24  = new Dimension(24, 24);
	public final static Dimension SPACER_32  = new Dimension(32, 32);


	public static void centerDialog (Component dialog, Component parent) {
		if (parent == null) {
			centerDialog(dialog);
			return;
		}

		Dimension dsize = dialog.getSize();
		Dimension ssize = dialog.getToolkit().getScreenSize();
		Dimension psize = parent.getSize();

		Point p = parent.getLocationOnScreen();
		int w = psize.width;
		int x = p.x + w / 2 - dsize.width / 2;
		if (x < 0) {
			x = 0;
		} else if (x + w > ssize.width) {
			x = ssize.width - w;
		}

		int h = psize.height;
		int y = p.y + h / 2 - dsize.height / 2;
		if (y < 0) {
			y = 0;
		} else if (y + h > ssize.height) {
			y = ssize.height - h;
		}

		dialog.setLocation(x, y);
	}


	public static void centerDialog (Component dialog) {
		Dimension screenSize = dialog.getToolkit().getScreenSize();
		Dimension size = dialog.getSize();
		screenSize.height = screenSize.height / 2;
		screenSize.width = screenSize.width / 2;
		size.height = size.height / 2;
		size.width = size.width / 2;
		int y = screenSize.height - size.height;
		int x = screenSize.width - size.width;
		dialog.setLocation(x, y);
	}


	public static void setChildrenFont (Container c, Class classes[], 
		Font f) {

		Component child[] = c.getComponents();
		int num_children = child.length;
		int num_classes = (classes == null ? 0 : classes.length);
		
		for (int i = 0; i < num_children; i++) {

			if (num_classes == 0) {
				child[i].setFont(f);
			} else {

				for (int j = 0; j < num_classes; j++) {
					if (classes[j] != null &&
					    classes[j].isInstance(child[i])) {
						child[i].setFont(f);
						break;
					}
				}
			}

			if (child[i] instanceof Container) {
				setChildrenFont((Container)child[i],
					classes, f);
			}
		}
	}


	public static void setChildrenBackground (Container c, Class classes[], 
		Color color) {

		Component child[] = c.getComponents();
		int num_children = child.length;
		int num_classes = (classes == null ? 0 : classes.length);
		
		for (int i = 0; i < num_children; i++) {

			if (num_classes == 0) {
				child[i].setBackground(color);
			} else {
				for (int j = 0; j < num_classes; j++) {
					if (classes[j] != null &&
					    classes[j].isInstance(child[i])) {
						child[i].setBackground(color);
						break;
					}
				}
			}

			if (child[i] instanceof Container) {
				setChildrenBackground((Container)child[i],
					classes, color);
			}
		}
	}


	public static void setChildrenForeground (Container c, Class classes[], 
		Color color) {

		Component child[] = c.getComponents();
		int num_children = child.length;
		int num_classes = (classes == null ? 0 : classes.length);
		
		for (int i = 0; i < num_children; i++) {

			if (num_classes == 0) {
				child[i].setForeground(color);
			} else {

				for (int j = 0; j < num_classes; j++) {
					if (classes[j] != null &&
					    classes[j].isInstance(child[i])) {
						child[i].setForeground(color);
						break;
					}
				}
			}

			if (child[i] instanceof Container) {
				setChildrenForeground((Container)child[i],
					classes, color);
			}
		}
	}


	/**
	 * Switch the between the Windows, Motif, and the Metal Look and Feel
	 */
	public static void setLookAndFeel(String plaf_name) 
		throws UnsupportedLookAndFeelException,
			IllegalAccessException,
			ClassNotFoundException,
			InstantiationException {

		if (plaf_name.equals(UIManager.getLookAndFeel().getName())) {
			return;
		}

		String plaf;
		if (plaf_name.equalsIgnoreCase("windows")) {
		    plaf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
	   	} else if (plaf_name.equalsIgnoreCase("motif") ||
	   	    plaf_name.equalsIgnoreCase("motif/cde")) {
			plaf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
	   	} else if (plaf_name.equalsIgnoreCase("metal")) {
		    plaf = "javax.swing.plaf.metal.MetalLookAndFeel";
		} else if (plaf_name.equalsIgnoreCase("macintosh")) {
		    plaf = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
		} else {
		    plaf = plaf_name;
		}

		UIManager.setLookAndFeel(plaf);
	}


	/**
	 * Switch the between the Windows, Motif, and the Metal Look and Feel
	 */
	public static void setLookAndFeel(String plaf_name, JComponent c) 
		throws UnsupportedLookAndFeelException,
			IllegalAccessException,
			ClassNotFoundException,
			InstantiationException {

		GuiUtils.setLookAndFeel(plaf_name);
	    
		SwingUtilities.updateComponentTreeUI(c);
		c.invalidate();
		c.validate();
		c.repaint();
	}


	public static String getLookAndFeel () {
		return (UIManager.getLookAndFeel().getName());
	}


	/**
	 * Find the hosting frame for the component.
	 */
	public static Frame getFrame(Component c) {
		if (c == null) {
			return (null);
		}

		Container p = c.getParent();
		for (; p != null; p = p.getParent()) {
	    		if (p instanceof Frame) {
	        		return (Frame) p;
	        	}
	    	}

	    	return (null);
	}

	
	/**
	 * Gets an array of installed look and feel names.
	 *
	 * @return  an array of LookAndFeel names
	 */
	public static String [] getLookAndFeelNames () {

		LookAndFeelInfo info[] = UIManager.getInstalledLookAndFeels();
		if (info == null) {
			return (null);
		}

		int num_plafs = info.length;
		String names[] = new String[num_plafs];
		for (int i = 0; i < num_plafs; i++) {
			names[i] = info[i].getName();
		}

		return (names);
	}


	/**
	 * Gets an array of installed look and feel classes.
	 *
	 * @return  an array of LookAndFeel class names
	 */
	public static String [] getLookAndFeelClasses () {

		LookAndFeelInfo info[] = UIManager.getInstalledLookAndFeels();
		if (info == null) {
			return (null);
		}

		int num_plafs = info.length;
		String classes[] = new String[num_plafs];
		for (int i = 0; i < num_plafs; i++) {
			classes[i] = info[i].getClassName();
		}

		return (classes);
	}


	/**
	 * Gets the default look and feel name for the operating system.
	 */
	public static String getDefaultLookAndFeelName () {

		LookAndFeelInfo info[] = UIManager.getInstalledLookAndFeels();
		String plaf = UIManager.getSystemLookAndFeelClassName();
		if (plaf != null && info != null) {
			for (int i = 0; i < info.length; i++) {
				if (plaf.equals(info[i].getClassName())) {
					return (info[i].getName());
				}
			}
		}


		String os = (String)System.getProperty("os.name").toLowerCase();
		if (os.indexOf("windows") >= 0) {
			plaf = "windows";
		} else if (os.indexOf("unix") >= 0) {
			plaf = "motif";
		} else if (os.indexOf("mac") >= 0) {
			plaf = "macintosh";
		} else {
			plaf = "metal";
		}

		return (plaf);
	}
}

