package com.vsi.xmlf.beans;

import javax.swing.JComponent;


import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;


public class ColumnLayout implements LayoutManager, java.io.Serializable {

	int _margin_width = 16;
	int _margin_height = 16;
	int _y_spacing = 1;


	public ColumnLayout () {
	}


	public ColumnLayout (int margin_width, int margin_height) {
		_margin_width = margin_width;
		_margin_height = margin_height;
	}


	public void setMarginWidth (int width) {
		_margin_width = width;
	}


	public void setMarginHeight (int height) {
		_margin_height = height;
	}


	public void setYSpacing (int y_spacing) {
		_y_spacing = y_spacing;
	}


	public void addLayoutComponent (String s, Component c) {
	}


	public void layoutContainer(Container c) {
		Insets insets = c.getInsets();
		int height = _margin_height + insets.top;
	  
		Component[] children = c.getComponents();
		Dimension compSize = null;
		for (int i = 0; i < children.length; i++) {
			compSize = children[i].getPreferredSize();
			children[i].setSize(compSize.width, compSize.height);
			children[i].setLocation(
				_margin_width + insets.left, height);
			height += compSize.height + _y_spacing;
		}
	}


	public Dimension minimumLayoutSize (Container c) {
		Insets insets = c.getInsets();
		int height = _margin_height + insets.top;
		int width = insets.left + insets.right;
		Component[] children = c.getComponents();
		Dimension compSize = null;
		for (int i = 0; i < children.length; i++) {
			compSize = children[i].getPreferredSize();
			height += compSize.height + _y_spacing;
			width = Math.max(width, compSize.width + insets.left + 
				insets.right + _margin_width * 2);
		}

		height += _margin_height + insets.bottom;
		return new Dimension(width, height);
	}
  
	public Dimension preferredLayoutSize (Container c) {
		return minimumLayoutSize(c);
	}
   
	public void removeLayoutComponent (Component c) {
	}
}

