package com.vsi.xmlf;

/**
 * This class encapsulates a XML-F voice-number element.
 *
 */
public 
class VoiceNumber implements PhoneNumber {


	protected String _tag = "voice-number";
	protected String _number = null;


	/**
	 * No args constructor.
	 */
	public VoiceNumber () {
	}



	/**
	 * Constructs a VoiceNumber object containg the specified phone number.
	 *
	 * @param  number  the phone number
	 */
	public VoiceNumber (String number) {
		_number = number;
	}
		

	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag() + ">");

		if (_number != null) {
			xml.append(_number);
		}
		
		xml.append("</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Get the voice number assigned to this VoiceNumber object.
	 */
	public String getNumber () {
		return (_number);
	}


	/**
	 * Set the voice number assigned to this VoiceNumber object.
	 *
	 * @param  number  value for the voice number
	 */
	public void setNumber (String number) {
		_number = number;
	}


	/**
	 * Returns a complete dial-able representation of this phone number.
	 */
	public String toString () {
		if (_number != null) {
			return (_number);
		} else {
			return ("");
		}
	}
}
