package com.vsi.xmlf;

/**
 * This class encapsulates a XML-F recipient element.
 *
 */
public 
class Recipient extends Person {

	protected String _tag = "recipient";


	/**
	 * No args constructor.
	 */
	public Recipient () {
	}


	/**
	 * Construct a Recipient from a Person object.
	 */
	public Recipient (Person p) {
		super(p.getName(), p.getCompany(),
			p.getFaxNumber(), p.getVoiceNumber());
	}


	/**
	 * Construct a Recipient from the provided information.
	 *
	 * @param  name  the name of the recipient.
	 * @param  company  the company of the recipient.
	 * @param  fax_number  the fax number of the recipient.
	 * @param  voice_number  the voice number of the recipient.
	 */
	public Recipient (String name, String company,
		PhoneNumber fax_number, PhoneNumber voice_number ) {

		super(name, company, fax_number, voice_number);
	}


	/**
	 * Construct a Recipient from the provided information.
	 *
	 * @param  fax_number  the fax number of the recipient.
	 */
	public Recipient (String fax_number) {

		super();
		setFaxNumber(fax_number);
	}


	/**
	 * Construct a Recipient from the XML text.
	 *
	 * @param  recipient_element  string containing the XML for the
	 * recipient.
	 */
	public Recipient (XmlElement recipient_element) {
		super(recipient_element);
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}
}
