package com.vsi.xmlf;

/**
 *
 *
 */
public
class Priority {


	public static final Priority LOW    = new Priority("low");
	public static final Priority NORMAL = new Priority("normal");
	public static final Priority HIGH   = new Priority("high");

	private String _value = null;

	/**
	 * Constructors are private since this class is for constants only.
	 */
	private Priority () {
	}

	private Priority (String value) {
		_value = value;
	}


	/**
	 * Gets a string representation of this Priority object.
	 *
	 * @return  the String representation of this priority
	 */
	public String toString () {
		return (_value);
	}

	/**
	 * Given a priority string return the corresponding 
	 * <code>Priority</code> object.
	 *
	 * @returns  The <code>Priority</code> object corresponding the the 
	 * given string.
	 */
	public static Priority stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("low")) {
			return (LOW);
		} else if (str.equalsIgnoreCase("normal")) {
			return (NORMAL);
		} else if (str.equalsIgnoreCase("high")) {
			return (HIGH);
		} else {
			return (null);
		}
	}
}
	
