#!/bin/sh
#
# ------------------------------------------------------------------------
# script to start/stop the VFS pickup service
#
[ ! -f /etc/vsifax.sh ] ||
{
	. /etc/vsifax.sh

	case "$1" in

	# ----------------------------------------------------------------
	# help targets
	#
	'-?'  | -help    | --help | \
	'-??' | -helpall | --helpall)
		echo "Usage: `basename $0` start|stop" ;;

	# ----------------------------------------------------------------
	# standard targets
	#
	start)		vfxpickup start	;;
	stop)		vfxpickup stop	;;

	# ----------------------------------------------------------------
	# HP-specific targets
	#
	start_msg)	echo "Starting the VSI-FAX VFS Pickup Service" ;;
	stop_msg)	echo "Stopping the VSI-FAX VFS Pickup Service" ;;

	esac
}
