#!/bin/sh
#
#+++FHDR+++
#
#	final processing for fxfaxapi installation
#
#	this script does the following:
#
#		1.	creates symlinks in /usr/include for all
#			headers in $VSIFAX/lib/dll
#		2.	creates symlinks in /usr/lib for all
#			libraries in $VSIFAX/lib/dll
#
#---FHDR---

# ------------------------------------------------------------------------
# echo an error msg line
#
echoerr ()
{
	echo "$*" >&2
}

# ------------------------------------------------------------------------
# Abort the installation
#
abort_install ()
{
	echoerr ""
	echoerr "Installation aborted."
	exit 1
}

# ------------------------------------------------------------------------
# check if running in windows
#
in_windows ()
{
	[ -d "c:/" ]
}

# ------------------------------------------------------------------------
# add a directory to the path
#
# Note that the directory is ALWAYS added to the end.
#
addpath ()
{
	dir="$1"

	sep=":"
	arg=""
	if in_windows
	then
		sep=";"
		arg="-i"
	fi

	foo=`echo "$PATH" | egrep $arg "^$dir$sep|$sep$dir$sep|$sep$dir$"`
	if [ $? -eq 0 ]
	then
		echo "$PATH"
	else
		echo "$PATH$sep$dir"
	fi

	unset dir sep arg foo
}

# ------------------------------------------------------------------------
# check that user is root
#
is_root ()
{
	in_windows && return 0

	unset uid
	unset euid
	eval `id | awk '
 BEGIN { uids="" }
 {
   for (i=1 ; i <= NF; i++ )
   {
      if ( $i ~ /^(uid|euid)=/ ) { split($i,ar,"("); uids= uids " " ar[1]}
    }
 }
 END { print uids }'`

	[ "$euid" = "" ] && euid=$uid

	[ $uid -eq 0 -o $euid -eq 0 ]
}

# ------------------------------------------------------------------------
# get name of root
#
rootname ()
{
	if in_windows
	then
		echo "Administrator"
	else
		grep '^[^:]*:[^:]*:0:' /etc/passwd | head -1 | cut -f1 -d:
	fi
}

# ------------------------------------------------------------------------
# check that user is root & abort if not
#
check_root ()
{
	is_root ||
	{
		root=`rootname`
		echoerr ""
		echoerr "Error: you are not running as \"$root\"."
		echoerr "You must be running as \"$root\" to proceed."
		abort_install
	}
}

# ------------------------------------------------------------------------
# help msg
#
usage ()
{
	echo "usage: $PGM [options]"
	echo "options:"
	echo "  -q     quick install"
	echo "  -s     silent install"
}

# ------------------------------------------------------------------------
# helpall msg
#
helpall ()
{
	usage

	echo "  -D     debug install"
}

# ------------------------------------------------------------------------
# setup all symlinks
#
setup_symlinks ()
{
	if [ -d "$VSIFAX/api/cpp" ]
	then
	(
		cd "$VSIFAX/api/cpp"

		if [ -d lib ]
		then
		(
			cd lib

			l=`ls *.a 2>/dev/null`
			if [ "$l" != "" ]
			then
				for i in $l
				do
					rm -f /usr/lib/$i
					ln -s "$VSIFAX/api/cpp/lib/$i" /usr/lib/$i
				done
			fi
		)
		fi

		if [ -d include ]
		then
		(
			cd include

			l=`ls *.h 2>/dev/null`
			if [ "$l" != "" ]
			then
				for i in $l
				do
					rm -f /usr/include/$i
					ln -s "$VSIFAX/api/cpp/include/$i" \
						/usr/include/$i
				done
			fi
		)
		fi
	)
	fi
}

# ------------------------------------------------------------------------
# main()
#
PATH=`addpath "$VSIFAX/bin"`
PATH=`addpath "$VSIFAX/lbin"`

# ------------------------------------------------------------------------
# process options
#
PGM=`basename $0`

DEBUG=

case "$1" in
	'-?' | -help | --help)
		usage
		exit 0
		;;

	'-??' | -helpall | --helpall)
		helpall
		exit 0
		;;

	'-V' | -version | --version)
		[ -x "$VSIFAX/bin/vfxadmin" ] && echo "$PGM: `vfxadmin version`"
		exit 0
		;;
esac

ARGS=`getopt "Dqs" $*` || { usage >&2; exit 1; }
set -- $ARGS

while [ "$1" != "" ]
do
	case "$1" in

	-D)
		DEBUG=-x
		shift
		;;

	-q)
		QUICK_INSTALL=yes	export QUICK_INSTALL
		shift
		;;

	-s)
		SILENT_INSTALL=yes	export SILENT_INSTALL
		shift
		;;

	--)
		shift
		break
		;;

	*)
		echoerr "Invalid argument \"$1\""
		abort_install
		;;
	esac
done

[ "$DEBUG" != "" ] && set $DEBUG

# ------------------------------------------------------------------------
# check that user is root
#
check_root

# ------------------------------------------------------------------------
# do any setups
#
setup_symlinks

exit 0
