package com.vsi.xmlf.beans;

import com.vsi.xmlf.*;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.util.Vector;


/**
 *
 */
public
class WizardSubmitForm extends WizardManager implements java.io.Serializable {

	protected transient TransportManager _mgr =
		TransportManager.getDefault();

	protected transient JDialog _dialog = null;

	protected transient OptionsPanel _options_panel = null;
	protected transient FaxOptions _options = null;

	protected transient RecipientsPanel _recipients = null;

	protected transient FinishedPanel _finished_panel = null;

	protected transient Vector _attachments = new Vector();

	protected Font _text_font = new Font("Dialog", Font.PLAIN, 12);

	protected static Class _set_classes[] = new Class[4];
	static {
	    try {
		_set_classes[0] = Class.forName("javax.swing.JLabel");
		_set_classes[1] = Class.forName("javax.swing.JButton");
		_set_classes[2] = Class.forName("javax.swing.JRadioButton");
		_set_classes[3] = Class.forName("javax.swing.JPanel");
	    } catch (Exception e) {
	    }
	}


	public WizardSubmitForm () {

		super();
		_options = new FaxOptions(".xmlfrc");

		java.net.URL url = getClass().getResource(
			"images/faxwizard.gif");
		if (url == null) {
			url = getClass().getResource(
				"com/vsi/xmlf/beans/images/faxwizard.gif");
		}

		if (url != null) {
			ImageIcon icon = new ImageIcon(url);
			setBitmapIcon(icon);
			setBitmapVisible(true);
		}

		_recipients = new RecipientsPanel();
		_options_panel = new OptionsPanel();
		_finished_panel = new FinishedPanel();

		addPanel(_recipients);
		addPanel(_options_panel);
		addPanel(_finished_panel);

		setFont(getFont());
		setTextFont(_text_font);
		setBackground(getBackground());	
		setForeground(getForeground());	

		show(0);
	}


	public void setBackground (Color c) {
		super.setBackground(c);

		if (_recipients == null) {
			return;
		}

		_recipients.setBackground(c);
		_options_panel.setBackground(c);
		_finished_panel.setBackground(c);
		GuiUtils.setChildrenBackground(this, _set_classes, c);
	}


	public void setForeground (Color c) {
		super.setForeground(c);

		if (_recipients == null) {
			return;
		}

		_recipients.setForeground(c);
		_options_panel.setForeground(c);
		_finished_panel.setForeground(c);
		GuiUtils.setChildrenForeground(this, _set_classes, c);
	}


	public Font getTextFont () {
		return (_text_font);
	}


	public void setTextFont (Font f) {

		_text_font = f;

		if (_recipients == null) {
			return;
		}

		_options_panel.setTextFont(f);
		_recipients.setTextFont(f);
	}


	public void setFont (Font f) {
		super.setFont(f);

		if (_recipients == null) {
			return;
		}

		_recipients.setFont(f);
		_options_panel.setFont(f);
		_finished_panel.setFont(f);

		GuiUtils.setChildrenFont(this, _set_classes, f);
	}


	class RecipientsPanel extends JPanel 
		implements WizardPanel, 
		RecipientSelectedListener,
		java.beans.PropertyChangeListener {

		protected transient PersonForm _to_form = null;
		protected transient RecipientsList _list = null;
		protected transient TitledBorder _to_border = null;

		protected transient JButton _add_btn = null;
		protected transient JButton _remove_btn = null;


		RecipientsPanel () {

			setName("recipients");
			setLayout(new BorderLayout());
			
			_to_border = new TitledBorder(new EtchedBorder(), "To");
			_to_form = new PersonForm();
			_to_form.setBorder(_to_border);
			_to_form.setTextFont(_text_font);
			_to_form.addPropertyChangeListener(this);	
			add(_to_form, BorderLayout.NORTH);

			_add_btn = new JButton("Add to list ");
			_add_btn.setToolTipText("Add the current \"To\" info " +
				"to the recipients list.");
			_add_btn.addActionListener(new AddAction());
			_add_btn.setEnabled(false);

			_list = new RecipientsList();
			_list.addRecipientSelectedListener(this);

			_remove_btn = new JButton("Remove from list");
			_remove_btn.setToolTipText("Remove the selected " +
				"recipient from the recipients list.");
			_remove_btn.addActionListener(new RemoveAction());
			_remove_btn.setEnabled(false);

			JPanel form = new JPanel();
			form.setLayout(new BoxLayout(form, BoxLayout.Y_AXIS));
			form.setBorder(new EmptyBorder(0, 2, 0, 2));

			_add_btn.setAlignmentX(Component.LEFT_ALIGNMENT);
			form.add(_add_btn);
			form.add(Box.createVerticalStrut(8));
			_list.setAlignmentX(Component.LEFT_ALIGNMENT);
			form.add(_list);
			_remove_btn.setAlignmentX(Component.LEFT_ALIGNMENT);
			form.add(_remove_btn);

			add(form, BorderLayout.CENTER);
		}


		Vector getRecipients () {
			return (_list.getRecipients());
		}


		Recipient getRecipient () {
			if (_to_form.isValidRecipient()) {
				return (_to_form.getRecipient());
			} else {
				return (null);
			}
		}


		public void recipientSelected (RecipientSelectedEvent e) {
			_remove_btn.setEnabled(e.getRecipient() != null);
		}


		public void propertyChange(java.beans.PropertyChangeEvent e) {
			String name = e.getPropertyName();
			if (name.equals(PersonForm.FAX_NUMBER)) {
				String value = (String)e.getNewValue();
				boolean enabled;
				if (value != null && 
				    value.trim().length() > 0) {
					enabled = true;
				} else {
					enabled = false;
				}

				_add_btn.setEnabled(enabled);

				int rows = _list.getRowCount();
				if (!enabled && rows < 1) {
					setNextButtonEnabled(false);
				} else if (enabled || rows > 0) {
					setNextButtonEnabled(true);
				}
			} else {
			}
		}


		class AddAction implements ActionListener,
			java.io.Serializable {

			AddAction () {
 			}

		 	public void actionPerformed(ActionEvent e) {
				_list.addRecipient(_to_form.getRecipient());
				_to_form.clear();
		 	}
		}


		class RemoveAction implements ActionListener,
			java.io.Serializable {

			RemoveAction () {
 			}

		 	public void actionPerformed(ActionEvent e) {
				_list.removeSelectedRecipient();

				int rows = _list.getRowCount();
				if (rows < 1) {
					_list.clearSelection();
					setNextButtonEnabled(
						_to_form.isValidRecipient());
				} else {
					setNextButtonEnabled(true);
				}
		 	}
		}


		public void setFont (Font f) {
			super.setFont(f);

			if (_to_border != null) {
				_to_border.setTitleFont(f);
			}
		}


		public void setTextFont (Font f) {
			if (_to_form != null) {
				_to_form.setTextFont(f);
			}
		}


		public void setForeground (Color c) {
			super.setForeground(c);

			if (_to_border != null) {
				_to_border.setTitleColor(c);
			}
		}


		public boolean leave (int direction) {
			return (true);
		}


		public void enter (int direction) {
			setNextButtonEnabled(_list.getRowCount() > 0 ||
				_to_form.isValidRecipient());
		}


		public boolean getHasHelp () {
			return (false);
		}

		public void doHelp (WizardManager mgr) {
		}


		public Component getComponent () {
			return ((Component)this);
		}
	}


	class OptionsPanel extends JPanel implements WizardPanel {

		protected transient JTextField _subject   = null;
		protected transient JRadioButton _yes_btn = null;
		protected transient JRadioButton _no_btn  = null;
		protected transient FaxOptionsForm _options_form = null;

		OptionsPanel () {

			setName("options");
			setLayout(new GridBagLayout());

			JLabel sl = new JLabel("Subject: ", JLabel.RIGHT);
			_subject = new JTextField("", 25);
			sl.setLabelFor(_subject);
			sl.setDisplayedMnemonic('S');

			JLabel cl = new JLabel(
				"Include a cover sheet?",
				JLabel.RIGHT);
			_yes_btn = new JRadioButton("yes");
			cl.setLabelFor(_yes_btn);
			cl.setDisplayedMnemonic('I');
			_yes_btn.setSelected(true);
			_no_btn = new JRadioButton("no");
			_no_btn.setSelected(false);
			ButtonGroup btn_group = new ButtonGroup();
			btn_group.add(_yes_btn);
			btn_group.add(_no_btn);
			JPanel radio_box = new JPanel();
			radio_box.setLayout(
				new BoxLayout(radio_box, BoxLayout.X_AXIS));
			radio_box.add(_yes_btn);
			radio_box.add(_no_btn);

			JPanel p = new JPanel();
			p.setLayout(new ColumnLayout(0, 0));

			p.add(new JLabel("To change account information, " +
				"sender information,", JLabel.LEFT));
			p.add(new JLabel("fax priority, fax resolution, " +
				"and/or notification settings,", JLabel.LEFT));
			p.add(new JLabel("click the \"Options...\" " +
				"button below.", JLabel.LEFT));
			p.add(Box.createVerticalStrut(8));
			JButton options_btn = new JButton("Options...");
			options_btn.addActionListener(new OptionsAction());
			p.add(options_btn);

			GridBagConstraints gbc = new GridBagConstraints();
			gbc.weightx = 1.0;
			gbc.anchor  = GridBagConstraints.WEST;
			gbc.fill    = GridBagConstraints.NONE;
			gbc.gridy   = 0;
			add(sl, gbc);
			gbc.gridy   = 1;
			gbc.fill    = GridBagConstraints.HORIZONTAL;
			add(_subject, gbc);

			gbc.gridy = 2;
			add(Box.createVerticalStrut(24), gbc);
		
			gbc.fill  = GridBagConstraints.NONE;
			gbc.gridy = 3;
			add(cl, gbc);
			gbc.gridy = 4;
			add(radio_box, gbc);	

			gbc.gridy = 5;
			add(Box.createVerticalStrut(24), gbc);
		
			gbc.fill  = GridBagConstraints.HORIZONTAL;
			gbc.gridy = 6;
			add(p, gbc);

			gbc.gridy = 7;
			add(Box.createVerticalGlue(), gbc);
		}


		String getSubject () {
			return (_subject.getText());
		}


		boolean getIncludeCoversheet () {
			return (_yes_btn.isSelected());
		}


		class OptionsAction implements ActionListener,
			java.io.Serializable {

			OptionsAction () {
 			}

		 	public void actionPerformed(ActionEvent e) {
	        	    if (_options_form == null) {
	            		_options_form = new FaxOptionsForm(_options);
	        	    }

			    _options_form.showDialog(WizardSubmitForm.this);
		 	}
		}



		public void setTextFont (Font f) {
			if (_subject != null) {
				_subject.setFont(f);
			}
		}


		public boolean leave (int direction) {
			return (true);
		}


		public void enter (int direction) {
		}


		public boolean getHasHelp () {
			return (false);
		}

		public void doHelp (WizardManager mgr) {
		}


		public Component getComponent () {
			return ((Component)this);
		}
	}


	class FinishedPanel extends JPanel implements WizardPanel {


		FinishedPanel () {

			setName("finish");
			setLayout(new ColumnLayout(0, 0));
			add(new JLabel("Your fax is now ready to send.",
				JLabel.LEFT));
			add(new JLabel("Click \"Finish\" to send the fax", 
				JLabel.LEFT));
			add(new JLabel("or \"Cancel\" to abort.",
				JLabel.LEFT));
		}


		public boolean leave (int direction) {
			return (true);
		}


		public void enter (int direction) {
		}


		public boolean getHasHelp () {
			return (false);
		}

		public void doHelp (WizardManager mgr) {
		}


		public Component getComponent () {
			return ((Component)this);
		}
	}


	public String getSubject () {
		return (_options_panel.getSubject());
	}


	public boolean getIncludeCoversheet () {
		return (_options_panel.getIncludeCoversheet());
	}

	
	public synchronized Recipient getRecipient () {
		return (_recipients.getRecipient());
	}


	public synchronized Vector getRecipients () {
		return (_recipients.getRecipients());
	}


	public synchronized Vector getAttachments () {
		return ((Vector)_attachments.clone());
	}


	public synchronized int getNumAttachments () {
		return (_attachments.size());
	}


	public synchronized void addAttachment (String filename) {
		if (filename != null) {
			_attachments.addElement(filename.trim());
		}
	}


	public synchronized void removeAttachment (String attachment) {
		_attachments.removeElement(attachment);
	}


	public synchronized void removeAttachmentAt (int index) {

		if (index > getNumAttachments()) {
			return;
		}

		try {
			_attachments.removeElementAt(index);
		} catch (Exception ignore) {
		}
	}


	public synchronized void clearAttachments () {
		_attachments.setSize(0);
	}


	public synchronized SubmitRequest getSubmitRequest () {

		/*
		 * Get all the data from the QuickSubmitForm bean and put it
		 * in the SubmitRequest object
		 */
		SubmitRequest request = new SubmitRequest();

		
		Recipient r = getRecipient();
		if (r != null) {
			request.addRecipient(r);
		}

		Vector v = getRecipients();
		int num_recipients = v.size();
		for (int i = 0; i < num_recipients; i++) {
			r = (Recipient)v.elementAt(i);
			request.addRecipient(r);
		}
		

		request.setAccount(_options.getAccount());
		request.setSender(_options.getSender());
		request.setIncludeCoversheet(getIncludeCoversheet());
		request.setSubject(getSubject());
		request.setPriority(_options.getPriority());
		request.setResolution(_options.getResolution());
		request.setNotifyWhen(_options.getNotifyWhen());
		request.setNotifyWho(_options.getNotifyWho());


		for (int i = 0; i < _attachments.size(); i++) {
			String attachment = (String)_attachments.elementAt(i);
			FileBody fb = new FileBody(attachment);
			request.addContent(fb);
		}

		return (request);
	}


	/**
	 * Add a response event listener.
	 *
	 * @param  l  The ResponseListener to add.
	 */
	public synchronized void addResponseListener (ResponseListener l) {
		_mgr.addResponseListener(l);
	}


	/**
         * Remove a response event listener.
         *
         * @param  l  The ResponseListener to remove.
         */
	public synchronized void removeResponseListener (ResponseListener l) {
		_mgr.removeResponseListener(l);
	}

	
	public void submit () {
		SubmitRequest request = getSubmitRequest();
		_mgr.backgroundSend(_options.getServerUrl(), request);
	}


	public void showDialog (Component parent) {
		createDialog(parent);
		GuiUtils.centerDialog(_dialog, parent);
		_dialog.show();
	}


	protected JDialog createDialog (Component parent) {

		if (_dialog != null) {
			return (_dialog);
		}

		_dialog = new JDialog(
			GuiUtils.getFrame(parent), "Fax Wizard", true);

		java.awt.Image icon;
		if (parent != null) {
			icon = GuiUtils.getFrame(parent).getIconImage();
		} else {
			java.net.URL url = getClass().getResource(
				"images/vsi16.gif");
			if (url == null) {
				url = getClass().getResource(
					"com/vsi/xmlf/beans/images/vsi16.gif");
			}
	
			ImageIcon iicon = new ImageIcon(url);
			icon = iicon.getImage();
		}
		GuiUtils.getFrame(_dialog).setIconImage(icon);

		addFinishActionListener(new FinishActionListener());
		addCancelActionListener(new CancelActionListener());

		_dialog.getContentPane().add(this);
		_dialog.pack();

		_dialog.addWindowListener(new AppCloser());

		return (_dialog);
	}


	class FinishActionListener implements ActionListener {

		FinishActionListener () {
		}

		public void actionPerformed (ActionEvent e) {
			_dialog.setVisible(false);
			submit();
		}
	}


	class CancelActionListener implements ActionListener {

		CancelActionListener () {
		}

		public void actionPerformed (ActionEvent e) {
			System.exit(1);
		}
	}


	class AppCloser extends WindowAdapter {

        	public void windowClosing(WindowEvent e) {
                	System.exit(0);
        	}
	}
}
