package com.vsi.xmlf.beans;

import com.vsi.xmlf.Person;
import com.vsi.xmlf.Recipient;
import com.vsi.xmlf.FaxNumber;
import com.vsi.xmlf.VoiceNumber;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import java.util.Vector;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;

/**
 *
 */
public
class RecipientsList extends JScrollPane implements java.io.Serializable {

	protected Vector _selection_listeners = new Vector();
	protected JTable _table = null;
	Vector _recipients = new Vector();


	public RecipientsList () {

		super();
		setName("RecipientsList");

		_table = new JTable();
		_table.setModel(new DataModel());
		_table.setAutoResizeMode(JTable.AUTO_RESIZE_NEXT_COLUMN);
		_table.setCellSelectionEnabled(false);
		_table.setColumnSelectionAllowed(false);
		_table.setRowSelectionAllowed(true);
		_table.setSelectionMode(0);
		_table.setShowVerticalLines(false);


		TableColumnModel tcm = _table.getColumnModel();
		TableColumn column;
		column = tcm.getColumn(0);
		column.setWidth(20);
		column.setMinWidth(5);
		column = tcm.getColumn(1);
		column.setWidth(12);
		column.setMinWidth(5);
		column = tcm.getColumn(2);
		column.setWidth(12);
		column.setMinWidth(5);
		column = tcm.getColumn(3);
		column.setWidth(12);
		column.setMinWidth(5);

		RecipientListListener listener = new RecipientListListener();
		_table.getSelectionModel().addListSelectionListener(listener);

		int rh = _table.getRowHeight();
		Dimension d = _table.getTableHeader().getPreferredSize();
		d.height = rh * 4 + _table.getTableHeader().getHeight();
		getViewport().setPreferredSize(d);

		setViewportView(_table);
		setColumnHeaderView(_table.getTableHeader());
		getViewport().setBackingStoreEnabled(true);
		setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
	}


	/**
	 *
	 */
	public synchronized Vector getRecipients () {
		return ((Vector)_recipients.clone());
	}



	public JTable getTable () {
		return (_table);
	}


	public synchronized void clearSelection () {
		_table.clearSelection();
	}


	public synchronized int getSelectedRow () {
		return (_table.getSelectedRow());
	}


	public synchronized Recipient getRecipientAt (int row) {

		if (row < 0 || row >= getRowCount()) {
			return (null);
		} else {
			return ((Recipient)_recipients.elementAt(row));
		}
	}


	public synchronized Recipient getSelectedRecipient () {
		return (getRecipientAt(getSelectedRow()));
	}


	public synchronized void addRecipient (Recipient r) {
		_recipients.addElement(r);
		_table.revalidate();
		_table.repaint();
	}


	public synchronized void removeRecipientAt (int row) {
		int num_rows = getRowCount();
		if (row < 0 || row >= num_rows) {
			return;
		}

		int selected = getSelectedRow();
		if (row <= selected) {
			_table.removeRowSelectionInterval(selected, selected);
		}

		_recipients.removeElementAt(row);

		if (row <= selected) {
			num_rows--;
			if (selected >= num_rows) {
				selected--;
			}
			if (selected >= 0) {
				_table.addRowSelectionInterval(
					selected, selected);
			}
		}

		_table.revalidate();
		_table.repaint();

		fireRecipientSelected(selected);
	}


	public synchronized void removeSelectedRecipient () {
		removeRecipientAt(getSelectedRow());
	}


	public synchronized int getRowCount () { 
		return (_recipients.size());
	}


    	class DataModel extends AbstractTableModel {
		
		final String _names[] = {
			"Name", "Company", "Fax Number", "Voice Number"};


		/*
		 * These methods always need to be implemented. 
		 */

		public int getColumnCount() { 
			return (_names.length);

		} 


		public int getRowCount () { 
			return (_recipients.size());
		}

		
		public Object getValueAt (int row, int col) {

			if (getRowCount() < 1) {
				return (null);
			}

			Recipient r = (Recipient)_recipients.elementAt(row);
			if (r == null) {
				return ("");
			}

			switch (col) {
			  case 0:
				return (r.getName());
			
			  case 1:	
				return (r.getCompany());

			  case 2:
				return (r.getFaxNumber());

			  case 3:
				return (r.getVoiceNumber());

			  default:
				return (null);
			}
		}


		public String getColumnName (int column) {
			return (_names[column]);
		}

	
		public Class getColumnClass (int col) {
	
			if (getRowCount() < 1) {
				return (null);
			}
	
			return (getValueAt(0, col).getClass());
		}


		public void setValueAt (Object value, int row, int col) {

			if (getRowCount() <= row) {
				_recipients.setSize(row + 1);
			}

			Recipient r = (Recipient)_recipients.elementAt(row);
			if (r == null) {
				r = new Recipient();
			}

			switch (col) {
			  case 0:
				r.setName((String)value);
				break;
			
			  case 1:	
				r.setCompany((String)value);
				break;

			  case 2:
				FaxNumber fn = new FaxNumber((String)value);
				r.setFaxNumber(fn);
				break;

			  case 3:
				VoiceNumber vn = new VoiceNumber((String)value);
				r.setVoiceNumber(vn);
				break;

			  default:
			}
		}
	}



	class RecipientListListener implements ListSelectionListener {

		public void valueChanged (ListSelectionEvent e) {
			fireRecipientSelected(e.getLastIndex());
		}
	}


	/**
	 * Add a message selected listener
	 */
	public synchronized void addRecipientSelectedListener (
		RecipientSelectedListener l) {

		if (!_selection_listeners.contains(l)) {
       			_selection_listeners.addElement(l);
		}
	}


	/**
	 * Remove a message selected listener
	 */
	public synchronized void removeRecipientSelectedListener (
		RecipientSelectedListener l) {

		if (_selection_listeners.contains(l)) {
			_selection_listeners.removeElement(l);
		}
	}

	/**
	 * Notify listening objects of a message selection
	 */
	protected void fireRecipientSelected (int row) {

		/*
		 * Create the event object
		 */
		RecipientSelectedEvent evt = 
			new RecipientSelectedEvent(this, getRecipientAt(row));

		/*
		 * Make a copy of the listener object vector so that it cannot
		 * be changed while we are firing events
		 */
		Vector v;
		synchronized(this) {
			v = (Vector) _selection_listeners.clone();
	      	}

		/*
	      	 * Fire the event to all listeners
		 */
	      	int count = v.size();
	      	for (int i = 0; i < count; i++) {
			RecipientSelectedListener l = 
				(RecipientSelectedListener)v.elementAt(i);
	         	l.recipientSelected(evt);
	      	}
	}
}
