package com.vsi.xmlf;

/**
 * This class sends a request to the server and waits for the response.
 *
 */
public
class ResponseThread extends Thread {

	protected TransportManager _mgr = null;
	protected Request _request = null;
	protected String _url = null;


	/**
	 * Constructs a ResponseThread object to send the request to the server
	 * specified by url using the passed in Transportmanager.
	 *
	 * @param  mgr  the TransportManager
	 * @param  url  the URL of the fax server
	 * @param  req  the request to send
	 */
	public ResponseThread (TransportManager mgr, String url, Request req) {

		_mgr = mgr;
		_url = url;
		_request = req;
	}


	/**
	 * This is the run() method for the Thread. It simply sends the
	 * request to the server and waits for the response. Once the response
	 * is recieved it fires a ResponseEvent to any listeners on the
	 * Request.
	 */
	public void run () {

		Response rsp = _mgr.send(_url, _request);
		if (rsp == null) {
			rsp = new Response(
				_mgr.getLastError(), "failed",
				_request.getServiceReference(),
				_request.getApplicationReference(),
				_request.getCommandReference());
		} 

		_mgr.fireResponseEvent(rsp);
		_request.fireResponseEvent(rsp);
	}
}

