package com.vsi.xmlf;

/**
 * This class encapsulates an XMLF sender or recipient element.
 *
 */
public abstract
class Person implements XmlfObject {

	protected String _name = null;
	protected String _company  = null;
	
	protected PhoneNumber _fax_number   = null;
	protected PhoneNumber _voice_number = null;


	/**
	 * No args constructor.
	 */
	public Person () {
	}


	public Person (String name, String company,
		PhoneNumber fax_number, PhoneNumber voice_number ) {

		_name = name;
		_company = company;

		_fax_number = fax_number;
		_voice_number = voice_number;
	}



	public Person (XmlElement person_element) {
		setFromXml(person_element);
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag() + ">\n");

		if (_name != null) {
			xml.append(indent + "\t<personal-name>" + 
				_name +"</personal-name>\n");
		}

		if (_company != null) {
			xml.append(indent + "\t<company-name>" + 
				_company +"</company-name>\n");
		}

		if (_fax_number != null) {
			xml.append(_fax_number.toXml(indent + "\t"));
		}

		if (_voice_number != null) {
			xml.append(_voice_number.toXml(indent + "\t"));
		}

		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());	
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  person_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement person_element) {
		if (person_element == null) {
			return;
		}

		XmlElement xml[] = person_element.getSubElements();
		setName(XmlElement.getData(xml, "personal-name"));
		setCompany(XmlElement.getData(xml, "company-name"));

		String str = XmlElement.getData(xml, "fax-number");
		if (str != null) {
			setFaxNumber(new FaxNumber(str));
	 	} else {
			XmlElement cf = 
				XmlElement.findElement(xml, "canonical-fax");
			if (cf != null) {
				setFaxNumber(new CanonicalFaxNumber(cf));
			}
		}
		
		str = XmlElement.getData(xml, "voice-number");
		if (str != null) {
			setVoiceNumber(new VoiceNumber(str));
	 	} else {
			XmlElement cv = 
				XmlElement.findElement(xml, "canonical-voice");
			if (cv != null) {
				setVoiceNumber(new CanonicalVoiceNumber(cv));
			}
		}
	}


	/**
	 * Gets the personal name assigned to the Person object.
	 *
	 * @return  the name of the person
	 */
	public String getName () {
		return (_name);
	}


	/**
	 * Gets the company name assigned to the Person object.
	 *
	 * @return  the company of the person
	 */
	public String getCompany () {
		return (_company);
	}


	/**
	 * Gets the fax number object assigned to the Person object.
	 *
	 * @return  the fax PhoneNumber of the person
	 */
	public PhoneNumber getFaxNumber () {
		return (_fax_number);
	}


	/**
	 * Gets the voice number object assigned to the Person object.
	 *
	 * @return  the voice PhoneNumber of the person
	 */
	public PhoneNumber getVoiceNumber () {
		return (_voice_number);
	}


	/**
	 * Assigns name as the personal name for the Person object.
	 *
	 * @param  name  the value to assign to the personal name.
	 */
	public void setName (String name) {
		_name = name;
	}


	/**
	 * Assigns company as the email address of the Person object.
	 *
	 * @param  company  the value to assign to the company name.
	 */
	public void setCompany (String company) {
		_company = company ;
	}


	/**
	 * Assigns fax_number as the fax number of the Person object.
	 *
	 * @param  fax_number  the value to assign to the fax number.
	 */
	public void setFaxNumber (PhoneNumber fax_number) {
		_fax_number = fax_number;
	}


	/**
	 * Assigns fax_number as the fax number of the Person object.
	 *
	 * @param  fax_number  the value to assign to the fax number.
	 */
	public void setFaxNumber (String fax_number) {
		_fax_number = new FaxNumber(fax_number);
	}


	/**
	 * Assigns voice_number as the voice number of the Person object.
	 *
	 * @param  voice_number  the value to assign to the voice number.
	 */
	public void setVoiceNumber (PhoneNumber voice_number) {
		_voice_number = voice_number;
	}


	/**
	 * Assigns voice_number as the voice number of the Person object.
	 *
	 * @param  voice_number  the value to assign to the voice number.
	 */
	public void setVoiceNumber (String voice_number) {
		_voice_number = new VoiceNumber(voice_number);
	}
}

