package com.vsi.xmlf;

/**
 *
 *
 */
public
class CurrentState {


	public static final CurrentState NEW =
				new CurrentState("new");
	public static final CurrentState IN_PROGRESS = 
				new CurrentState("in-progress");
	public static final CurrentState FINISHED =
				new CurrentState("finished");
	

	private String _value = null;


	/**
	 * Constructors are private since this class is for constants only.
	 */
	private CurrentState () {
	}


	/**
	 * Constructors are private since this class is for constants only.
	 */
	private CurrentState (String value) {
		_value = value;
	}


	public String toString () {
		return (_value);
	}


	/**
	 * Given a current-state string return the corresponding 
	 * <code>CurrentState</code> object.
	 *
	 * @returns  The <code>CurrentState</code> object corresponding the the 
	 * given string.
	 */
	public static CurrentState stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("new")) {
			return (NEW);
		} else if (str.equalsIgnoreCase("in-progress")) {
			return (IN_PROGRESS);
		} else if (str.equalsIgnoreCase("finished")) {
			return (FINISHED);
		} else {
			return (null);
		}
	}
}

