package com.vsi.xmlf;

/**
 * This class encapsulates a XMLF canonical phone number
 * element. It is abstract and is subclassed by the
 * CanonicalFaxNumber and CanonicalVoiceNumber classes.
 *
 */
public abstract
class CanonicalPhoneNumber implements PhoneNumber {

	protected String _area_code    = null;
	protected String _country_code = null;
	protected String _local_number = null;
	protected String _extension    = null;


	/**
	 * No args constructor.
	 */
	public CanonicalPhoneNumber () {
	}


	/**
	 * Construct a CanonicalPhoneNumber object based on the passed in
	 * attributes.
	 *
	 * @param  country_code  the country code of the phone number
	 * @param  area_code     the area code of the phone number
	 * @local_number         the local number of the phone number
	 * @extension            the extension of the phone number 
	 */
	public CanonicalPhoneNumber (String country_code, String area_code,
		String local_number, String extension) {

		_country_code = _country_code;
		_area_code    = area_code;
		_local_number = local_number;
		_extension    = extension;
	}


	/**
	 *
	 */
	public CanonicalPhoneNumber (XmlElement element) {
		setFromXml(element);
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag() + ">\n");

		if (_country_code != null) {
			xml.append(indent + "\t<country-code>" + 
				_country_code + "</country-code>\n");
		}
		
		if (_area_code != null) {
			xml.append(indent + "\t<area-code>" + 
				_area_code + "</area-code>\n");
		}
		
		if (_local_number != null) {
			xml.append(indent + "\t<local-number>" + 
				_local_number + "</local-number>\n");
		}
		
		if (_extension != null) {
			xml.append(indent + "\t<extension>" + 
				_extension + "</extension>\n");
		}

		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  element  the XML data to assign from
	 */
	public void setFromXml (XmlElement element) {

		_area_code    = null;
		_country_code = null;
		_local_number = null;
		_extension    = null;

		if (element == null) {
			return;
		}

		XmlElement xml[] = element.getSubElements();
		setAreaCode(XmlElement.getData(xml, "area-code"));
		setCountryCode(XmlElement.getData(xml, "country-code"));
		setLocalNumber(XmlElement.getData(xml, "local-number"));
		setExtension(XmlElement.getData(xml, "extension"));
	}


	/**
	 * Gets the country code assigned to this CanonicalPhoneNumber object.
	 */
	public String getCountryCode () {
		return (_country_code);
	}


	/**
	 * Gets the area code assigned to this CanonicalPhoneNumber object.
	 */
	public String getAreaCode () {
		return (_area_code);
	}


	/**
	 * Gets the local number assigned to this CanonicalPhoneNumber object.
	 */
	public String getLocalNumber () {
		return (_local_number);
	}


	/**
	 * Gets the extension assigned to this CanonicalPhoneNumber object.
	 */
	public String getExtension () {
		return (_extension);
	}


	/**
	 * Sets the country code assigned to this CanonicalPhoneNumber object.
	 *
	 * @param  country_code  value for the country code
	 */
	public void setCountryCode (String country_code) {
		_country_code = country_code;
	}


	/**
	 * Sets the area code assigned to this CanonicalPhoneNumber object.
	 *
	 * @param  area_code  value for the area code.
	 */
	public void setAreaCode (String area_code) {
		_area_code = area_code;
	}


	/**
	 * Sets the local number assigned to this CanonicalPhoneNumber object.
	 *
	 * @param  local_number  value for the local number.
	 */
	public void setLocalNumber (String local_number) {
		_local_number = local_number;
	}


	/**
	 * Sets the extension assigned to this CanonicalPhoneNumber object.
	 *
	 * @param  extension  value for the extension.
	 */
	public void setExtension (String extension) {
		_extension = extension;
	}


	public String toString () {
		StringBuffer buf = new StringBuffer();

		if (_country_code != null) {
			buf.append(_country_code);
		}

		if (_area_code != null) {
			buf.append(_area_code);
		}

		if (_local_number != null) {
			buf.append(_local_number);
		}

		if (_extension != null) {
			buf.append(_extension);
		}


		return (buf.toString());
	}
}

