package com.vsi.xmlf;

/**
 * This class encapsulates an XML-F fax-cancel-rsp document.
 *
 */
public
class CancelResponse extends Response implements java.io.Serializable {

	/**
	 * No args constructor.
	 */
	public CancelResponse () {
		setTag("fax-cancel-response");
	}


	/**
	 * Create a CancelResponse object based on the passed in parameters.
	 *
	 * @param  results_message  the status message of the cancel-request
	 * @param  results_status  the status of the cancel-request
	 * @param  svc_ref  the value for the service-reference element
	 * @param  app_ref  the value for the application-reference element
	 * @param  cmd_ref  the value for the command-reference element
	 */
	public CancelResponse (String results_message, String results_status,
		String svc_ref, String app_ref, String cmd_ref) {

		super(results_message, results_status, 
			svc_ref, app_ref, cmd_ref);
		setTag("fax-cancel-response");
	}


	/**
	 * This constructor creates a <code>CancelResponse</code> object
	 * from the passed in XML.
	 *
	 * @param  the XML to use in constructing the object
	 */
	public CancelResponse (XmlElement element) {
		setFromXml(element);
		setTag("fax-cancel-response");
	}
}

