import com.vsi.xmlf.CmdLine;
import com.vsi.xmlf.Response;
import com.vsi.xmlf.ResponseEvent;
import com.vsi.xmlf.ResponseListener;

import com.vsi.xmlf.beans.Splash;
import com.vsi.xmlf.beans.WizardSubmitForm;


/**
 * This class implements a fax wizard application. It is
 * intended to demonstrate the XML-F Components.
 *
 */
class FaxWizard extends WizardSubmitForm implements ResponseListener {

	public static void main (String args[]) {

		String plaf = com.vsi.xmlf.beans.GuiUtils.
					getDefaultLookAndFeelName();

		// Parse the command line
		CmdLine cmdline = new CmdLine("l:");
		for (int c = cmdline.getOpt(args);
			c != CmdLine.EOF; 
			c = cmdline.getOpt(args)) {

			switch (c) {

			  case 'l':
				plaf = cmdline.getOptArg();
				break;

			  case CmdLine.ERROR:
				System.err.println(cmdline.getErrorMsg());
				System.exit(1);
				break;
			}
		}

		// Set the look and feel for the app
		try {
			com.vsi.xmlf.beans.GuiUtils.setLookAndFeel(plaf);
		} catch (Exception ignore) {
		}
		
		// Create and display the splash screen	
		Splash splash = new Splash("XML-F Fax Wizard",
			"faxwizard.gif", "vsi16.gif");
		splash.setVisible(true);

		// Create the FaxWizard ui
		FaxWizard fw = new FaxWizard();

		// Add any arguments as attachements 
		for (int i = cmdline.getOptIndex(); i < args.length; i++) {
			fw.addAttachment(args[i]);
		}

		// Hide the splash screen
		splash.setVisible(false);
		splash = null;

		// Display the fax wizard
		fw.showDialog(null);
	}


	FaxWizard () {

		// Create the WizardSubmitForm ui and add a listener
		// for responses
		addResponseListener(this);
	}


	public void response (ResponseEvent evt) {
		Response rsp = evt.getResponse();
		System.out.println(rsp.toXml());
		System.exit(0);
	}
}

