# +++PHDR+++
#
# Procedure:	vclutils__BindMultiScrollbar
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vclutils__BindMultiScrollbar { scrollbar args } {

	#
	# Bind all the lists to the scrollbar
	#
	if { $scrollbar != "" } {
		$scrollbar configure -command [list vclutils__Yview $args]
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__BindMultiList
#
# Description:	Binds a set of listboxes so that they act together
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# double_click          Command to execute when an item is double clicked
# args                  Listboxes to bind together
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__BindMultiList { double_click args } {

	#
	# Bind the lists so they act together
	#
	foreach l $args {
		bind $l <B2-Motion> [list vclutils__DragTo %x %y $args]
		bind $l <Button-2>  [list vclutils__Mark %x %y $args]
		bind $l <Button-1>  [list vclutils__Select %y $args]
		bind $l <B1-Motion> [list vclutils__Select %y $args]
		bind $l <Shift-Button-1>  [list vclutils__Select %y $args]
		bind $l <Shift-B1-Motion> [list vclutils__Select %y $args]
		bind $l <Key-Up> [list vclutils__KeySelect $l active -1 $args]
		bind $l <Key-Down> [list vclutils__KeySelect $l active 1 $args]
		bind $l <Control-Home> [list vclutils__KeySelect $l 0 0 $args]
		bind $l <Control-End> [list vclutils__KeySelect $l end 0 $args]

		if { $double_click != "" } {
			bind $l <Double-Button-1> [list $double_click]
		}
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__GetSelected
#
# Description:	Gets the selected item string from a listbox
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# list                  Listbox to get selected item from
#
# Returns:	The selected item
#
#
# Notes:
#
# ---PHDR---

proc vclutils__GetSelected { list } {
	set i [$list curselection]
	if { $i == "" } { return "" }

	set item [ $list get [lindex $i 0] ]
	return "$item"
}


# +++PHDR+++
#
# Procedure:	vclutils__SetSelected
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vclutils__SetSelected { index args } {
	foreach l $args {
		$l select clear 0 end
		$l select anchor $index
		$l select set anchor $index
	}

	return
}


# +++PHDR+++
#
# Procedure:	vclutils__Yview
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	Nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__Yview { lists args } {
	foreach l [split $lists] {
		eval { $l yview } $args
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__KeySelect
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	Nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__KeySelect { l listindex adjust lists } {
	#
	# Get the new selected index and set each listbox in the list
	# to the new selected index
	#
	set i [expr [$l index $listindex] + $adjust]
	foreach lb [split $lists] {
		$lb select clear 0 end
		$lb selection set $i $i
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__Select
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	Nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__Select { y lists } {
	foreach l [split $lists] {
		$l select clear 0 end
		$l select anchor [$l nearest $y]
		$l select set anchor [$l nearest $y]
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__DragTo
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	Nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__DragTo { x y lists } {
	foreach l [split $lists] {
		$l scan dragto $x $y
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__Mark
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	Nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__Mark { x y lists } {
	foreach l [split $lists] {
		$l mark dragto $x $y
	}
}


# +++PHDR+++
#
# Procedure:	vclutils__SwapItem
#
# Description:	Moves the selected item from one list to another.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__SwapItem { from_list to_list } {

	set index [$from_list curselection]
	if { $index == "" } {
		return
	}

	set item [ $from_list get [lindex $index 0] ]
	$from_list delete $index

	$to_list insert end $item
}


# +++PHDR+++
#
# Procedure:	vclutils__SwapAllItems
#
# Description: Moves all items in one list to the other.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__SwapAllItems { from_list to_list } {

	while { [set item [$from_list get 0]] != "" } {
		$to_list insert end $item
		$from_list delete 0
	}
}

# +++PHDR+++
#
# Procedure:	vclutils__LoadSource
#
# Description:	Loads the specified TCL source file. Firsts looks in the
#		current directory and then in $VSIFAX/lib/faxtcl.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# procedure		Name of the procedure we want
# filename              Name of the TCL source file to load
#
# Returns:	1 on success, 0 on failure
#
#
# Notes:
#
# ---PHDR---

proc vclutils__LoadSource { procedure filename } {
	global env

	if { [info commands $procedure] != "" } {
		return 1
	}

	#
	# Look for the passed filename first
	#
	if { [file exists $filename] } {
		source $filename
		return 1
	}

	#
	# Hopefully the file is in $VSIFAX/lib/faxtcl
	#
	if { ![info exists env(VSIFAX)] } {
		set env(VSIFAX) /usr/vsifax3
	}
	set basename [file tail $filename]
	set fullpath $env(VSIFAX)/lib/faxtcl/bin/$basename
	if { [file exists $fullpath] } {
		source $fullpath
		return 1
	}

	#
	# We get here something went wrong
	#
	return 0
}

# +++PHDR+++
#
# Procedure:	vclutils__LoadPixmap
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
# Returns:	id on success, "" on failure
#
#
# Notes:
#
# ---PHDR---

proc vclutils__LoadPixmap { id filename } {
	global env

	#
	# Look for the passed filename first
	#
	if { [file exists $filename] } {
		return [ image create pixmap $id -file $filename ]
	}

	#
	# Hopefully the file is in $VSIFAX/lib/faxtcl/pixmaps
	#
	if { ![info exists env(VSIFAX)] } {
		return ""
	}
	set basename [file tail $filename]
	set fullpath $env(VSIFAX)/lib/faxtcl/pixmaps/$basename
	if { [file exists $fullpath] } {
		return [ image create pixmap $id -file $fullpath ]
	}

	return ""
}


# +++PHDR+++
#
# Procedure:	vclutils__MoveDialog
#
# Description:	Moves a dialog window relative to a parent window.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# dialog                pathname of dialog to move
# parent                pathname of parent window
# x                     offset from parent location x
# y                     offset from parent location y
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__MoveDialog { dialog parent x y } {

	#
	# Get the location of the parent
	#
	if { $parent != "" } {
		set px [ winfo x $parent ]
		set py [ winfo y $parent ]
	} else {
		set px 0
		set py 0
	}

	#
	# Compute the new position and move the dialog
	#
	set newx [ expr $px + $x ]
	set newy [ expr $py + $y ]
	catch { wm geometry $dialog "+$newx+$newy" }
}

#
# Procedure:	vclutils__CenterDialog
#
# Description:	Centers a dialog window over a parent window
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# dialog                pathname of dialog to center
# parent                pathname of parent window
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__CenterDialog { dialog parent } {

	#
	# Get the dimensions of the screen
	#
	set dsp_width  [ winfo screenwidth  $dialog ]
	set dsp_height [ winfo screenheight $dialog ]

	#
	# Get the dimensions and location of the parent window
	#
	if { $parent != "" } {
		set pw [ winfo width  $parent ]
		set ph [ winfo height $parent ]
		set px [ winfo rootx $parent ]
		set py [ winfo rooty $parent ]
	} else {
		set pw $dsp_width
		set ph $dsp_height
		set px 0
		set py 0
	}

	#
	# Get the dimensions of the dialog
	#
	# We have to hide it first so the user doesn't see it move
	#
	wm withdraw $dialog
	update
	set width  [ winfo width  $dialog ]
	set height [ winfo height $dialog ]

	#
	# Get the new x and y and make sure they are valid
	#
	set x [ expr ($px + ($pw / 2)) - ($width / 2) ]
	set y [ expr ($py + ($ph / 2)) - ($height / 2) ]

	if { $x < 1 } {
		set x 0
	} elseif { [ expr $x + $width ] > $dsp_width } {
		set x [ expr $dsp_width - $width ]
	}

	if { $y < 1 } {
		set y 0
	} elseif { [ expr $y + $height ] > $dsp_height } {
		set y [ expr $dsp_height - $height ]
	}

	#
	# Now move the dialog and remap it
	#
	wm geometry $dialog "+$x+$y"
	catch { wm deiconify $dialog }
}


# +++PHDR+++
#
# Procedure:	vclutils__LockSize
#
# Description:	Locks the current size of a window
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# w                     pathname of window to lock
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vclutils__LockSize { w } {

	set height [ winfo height $w ]
	set width  [ winfo width  $w ]
	wm minsize $w $width $height
	wm maxsize $w $width $height
	wm resizable $w 0 0
}

