# ------------------------------------------------------------------------
# sys-start.tcl
#
#	Description:
#
#	This script is called at scheduler startup
#
# FoDC Failover: 
#	Issue command to switch on the main FoDC device and disable backup
#
# ------------------------------------------------------------------------
set VSIFAX	$env(VSIFAX)

# ------------------------------------------------------------------------
# Configurable globals
# ------------------------------------------------------------------------
set FODC_MAIN_DEVICE "FoDC"
set FODC_FAILOVER_DEVICE "FoDC2"

# ------------------------------------------------------------------------
# Check if FoDC Failover is enabled
# ------------------------------------------------------------------------
set FODC_MAIN_CONFIGURED ""
set FODC_FAILOVER_CONFIGURED ""
set FODC_FAILOVER_ENABLED "0"
catch {set FODC_FAILOVER_ENABLED [exec "$VSIFAX/bin/vfxadmin" config -slqb -i $FODC_MAIN_DEVICE DEVICE failover]}
catch {set FODC_MAIN_CONFIGURED [exec "$VSIFAX/bin/vfxadmin" config -slq -i $FODC_MAIN_DEVICE DEVICE accountid]}
catch {set FODC_FAILOVER_CONFIGURED [exec "$VSIFAX/bin/vfxadmin" config -slq -i $FODC_FAILOVER_DEVICE DEVICE accountid]}
if {[string compare "$FODC_FAILOVER_ENABLED" "1"] == 0
		&& [string length "$FODC_MAIN_CONFIGURED"] > 0
		&& [string length "$FODC_FAILOVER_CONFIGURED"] > 0 } {
	catch {exec "$VSIFAX/bin/vfxadmin" enable $FODC_MAIN_DEVICE}
	catch {exec "$VSIFAX/bin/vfxadmin" disable $FODC_FAILOVER_DEVICE}
}

exit 0 
