package com.vsi.xmlf.beans;


import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.IOException;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.metal.*;


/**
  *
  */
public class FaxOptionsForm extends JPanel {

	protected JDialog _dialog = null;

	protected JRadioButton _std_btn = null;
	protected JRadioButton _fine_btn = null;
	protected JRadioButton _low_priority_btn = null;
	protected JRadioButton _normal_priority_btn = null;
	protected JRadioButton _high_priority_btn = null;

	protected JTextField _server_url = null;
	protected JTextField _id = null;
	protected JTextField _subid = null;
	protected JTextField _mail_address = null;

	protected JTextField _name = null;
	protected JTextField _company = null;
	protected JTextField _fax_number = null;
	protected JTextField _voice_number = null;

	protected JTextField _notify_who = null;
	protected JRadioButton _always_btn = null;
	protected JRadioButton _never_btn = null;
	protected JRadioButton _onsuccess_btn = null;
	protected JRadioButton _onfailure_btn = null;

	protected TitledBorder _priority_border = null;
	protected TitledBorder _resolution_border = null;
	protected TitledBorder _notification_border = null;

	protected FaxOptions _options = null;


	protected static Class _set_classes[] = new Class[4];
	static {
	    try {
		_set_classes[0] = Class.forName("javax.swing.JLabel");
		_set_classes[1] = Class.forName("javax.swing.JButton");
		_set_classes[2] = Class.forName("javax.swing.JRadioButton");
		_set_classes[3] = Class.forName("javax.swing.JTabbedPane");
	    } catch (Exception e) {
	    }
	}


	public FaxOptionsForm () {
		_options = new FaxOptions(".xmlfrc");
		createTabs();
	}

	
	public FaxOptionsForm (FaxOptions options) {
		_options = options;
		createTabs();
	}

	protected void createTabs () {
		
		setLayout(new BorderLayout());

 		JTabbedPane tabs = new JTabbedPane();
		JPanel sender_panel = buildSenderPanel();
		JPanel account_panel = buildAccountPanel();
		JPanel param_panel = buildParametersPanel();

		tabs.addTab("Sender", null, sender_panel);
		tabs.addTab("Account", null, account_panel);
		tabs.addTab("Parameters", null, param_panel);

		add(tabs, BorderLayout.CENTER);

		setFont(getFont());
		setBackground(getBackground());
		setForeground(getForeground());

		reset();
	}


	protected JPanel buildParametersPanel () {

		JPanel p = new JPanel();
		p.setLayout(new ColumnLayout());

		p.add(new JLabel("The following information " + 
			"affects how faxes are sent.", JLabel.LEFT));
	
		p.add(Box.createRigidArea(GuiUtils.SPACER_16));


		ButtonGroup group = new ButtonGroup();

		_std_btn = new JRadioButton("standard (100x200)");
		group.add(_std_btn);

		_fine_btn = new JRadioButton("fine (200x200)");
		group.add(_fine_btn);

		JPanel res = new JPanel();
		_resolution_border = 
			new TitledBorder(new EtchedBorder(), "Resolution");
		res.setBorder(_resolution_border);
		res.setLayout(new BoxLayout(res, BoxLayout.X_AXIS));
		res.add(Box.createHorizontalStrut(8));
		res.add(_std_btn);
		res.add(_fine_btn);
		p.add(res);


		group = new ButtonGroup();

		_low_priority_btn = new JRadioButton("low");
		group.add(_low_priority_btn);

		_normal_priority_btn = new JRadioButton("normal");
		group.add(_normal_priority_btn);

		_high_priority_btn = new JRadioButton("high");
		group.add(_high_priority_btn);

		JPanel priority = new JPanel();
		priority.setLayout(new BoxLayout(priority, BoxLayout.X_AXIS));
		_priority_border = 
			new TitledBorder(new EtchedBorder(), "Priority");
		
		priority.setBorder(_priority_border);
		priority.add(Box.createHorizontalStrut(8));
		priority.add(_low_priority_btn);
		priority.add(_normal_priority_btn);
		priority.add(_high_priority_btn);
		p.add(priority);

	
		group = new ButtonGroup();

		_onfailure_btn = new JRadioButton("on failure");
		group.add(_onfailure_btn);

		_onsuccess_btn = new JRadioButton("on success");
		group.add(_onsuccess_btn);

		_always_btn = new JRadioButton("always");
		group.add(_always_btn);

		_never_btn = new JRadioButton("never");
		group.add(_never_btn);

		GridBagLayout gb = new GridBagLayout();
		JPanel notify = new JPanel(gb);
		_notification_border =
			new TitledBorder(new EtchedBorder(), "Notification");
		notify.setBorder(_notification_border);

		GridBagConstraints gbc = new GridBagConstraints();
		gbc.weightx = 0.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.gridwidth = GridBagConstraints.REMAINDER;

		gbc.insets.left += 8;
		notify.add(new JLabel("When:", JLabel.LEFT), gbc);
		gbc.weightx = 0.0;
		gbc.gridwidth = 1;
		notify.add(_onfailure_btn, gbc);	
		gbc.insets.left -= 8;
		notify.add(_onsuccess_btn, gbc);	
		notify.add(_always_btn, gbc);	
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		notify.add(_never_btn, gbc);	

		gbc.insets.left += 8;
		gbc.weightx = 0.0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.insets.top += 8;
		notify.add(new JLabel("Who:", JLabel.LEFT), gbc);
		_notify_who = (JTextField)p.add(new JTextField(20));
		gbc.insets.top -= 8;
		notify.add(_notify_who, gbc);	
		
		p.add(notify);

		return (p);
	}


	protected JPanel buildSenderPanel () {

		JPanel p = new JPanel();
		p.setLayout(new ColumnLayout());

		p.add(new JLabel("The following information " + 
			"is needed to send faxes.", JLabel.LEFT));
		p.add(new JLabel("This information is used on the " + 
			"fax coversheet", JLabel.LEFT));
		p.add(new JLabel("and for information logging purposes.", 
			JLabel.LEFT));
		
		p.add(Box.createRigidArea(GuiUtils.SPACER_16));

		JLabel l;
		l = (JLabel)p.add(new JLabel("Name: (required)", JLabel.LEFT));
		_name = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_name);
		l.setDisplayedMnemonic('N');
		
		p.add(Box.createRigidArea(GuiUtils.SPACER_08));
			
		l = (JLabel)p.add(new JLabel("Company:", JLabel.LEFT));
		_company = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_company);
		l.setDisplayedMnemonic('C');

		p.add(Box.createRigidArea(GuiUtils.SPACER_08));
		
		l = (JLabel)p.add(new JLabel("Fax Number:", JLabel.LEFT));
		_fax_number = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_fax_number);
		l.setDisplayedMnemonic('F');

		p.add(Box.createRigidArea(GuiUtils.SPACER_08));
		
		l = (JLabel)p.add(new JLabel("Voice Number:", JLabel.LEFT));
		_voice_number = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_voice_number);
		l.setDisplayedMnemonic('V');

		return (p);
	}


	protected JPanel buildAccountPanel () {

		JPanel p = new JPanel();
		p.setLayout(new ColumnLayout());

		p.add(new JLabel("The following information " + 
			"is needed to send a fax.", JLabel.LEFT));
		p.add(new JLabel("If you do not know the requested " + 
			"information, contact your", JLabel.LEFT));
		p.add(new JLabel("system administrator.", JLabel.LEFT));
		
		p.add(Box.createRigidArea(GuiUtils.SPACER_16));

		p.add(new JLabel("Fax Server URL: (required)", JLabel.LEFT));
		_server_url = (JTextField)p.add(new JTextField(24));

		p.add(Box.createRigidArea(GuiUtils.SPACER_08));

		JLabel l = (JLabel)p.add(new JLabel(
			"Your Fax Account Id: (required)", JLabel.LEFT));
		_id = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_id);
		l.setDisplayedMnemonic('I');
		
		p.add(Box.createRigidArea(GuiUtils.SPACER_08));

		l = (JLabel)p.add(new JLabel(
			"Your Fax Account Sub-Id:", JLabel.LEFT));
		_subid = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_subid);
		l.setDisplayedMnemonic('S');
		
		p.add(Box.createRigidArea(GuiUtils.SPACER_08));
			
		l = (JLabel)p.add(new JLabel(
			"Your Email Address:", JLabel.LEFT));
		_mail_address = (JTextField)p.add(new JTextField(24));
		l.setLabelFor(_mail_address);
		l.setDisplayedMnemonic('M');
		
		return (p);
	}


	class CancelAction implements ActionListener {

		CancelAction () {
		}

	        public void actionPerformed(ActionEvent e) {
			_dialog.setVisible(false);
			reset();
	        }
	}


	class OkAction implements ActionListener {

		OkAction () {
		}

		public void actionPerformed(ActionEvent e) {
			_dialog.setVisible(false);
			getValuesFromForm();
			save();
	        }
	}



	protected void getValuesFromForm () {

		_options.setServerUrl(_server_url.getText());
		_options.setId(_id.getText());
		_options.setSubid(_subid.getText());
		_options.setMailAddress(_mail_address.getText());

		if (_std_btn.isSelected()) {
			_options.setResolution("std");
		} else if (_fine_btn.isSelected()) {
			_options.setResolution("fine");
		}
	
		if (_low_priority_btn.isSelected()) {
			_options.setPriority("low");
		} else if (_normal_priority_btn.isSelected()) {
			_options.setPriority("normal");
		} else if (_high_priority_btn.isSelected()) {
			_options.setPriority("high");
		}

		_options.setFromName(_name.getText());
		_options.setFromCompany(_company.getText());
		_options.setFromFaxNumber(_fax_number.getText());
		_options.setFromVoiceNumber(_voice_number.getText());

		if (_onfailure_btn.isSelected()) {
			_options.setNotifyWhen("on-failure");
		} else if (_onsuccess_btn.isSelected()) {
			_options.setNotifyWhen("on-success");
		} else if (_always_btn.isSelected()) {
			_options.setNotifyWhen("always");
		} else if (_never_btn.isSelected()) {
			_options.setNotifyWhen("never");
		}

		_options.setNotifyWho(_notify_who.getText());
	}


	protected void reset () {
 
		_server_url.setText(_options.getServerUrl());
		_id.setText(_options.getId());
		_subid.setText(_options.getSubid());
		_mail_address.setText(_options.getMailAddress());

		String res = _options.getResolution();
		if (res == null) {
			_fine_btn.setSelected(true);
		} else if (res.equals("std")) {
			_std_btn.setSelected(true);
		} else if (res.equals("fine")) {
			_fine_btn.setSelected(true);
		}

		String priority = _options.getPriority();
		if (priority == null) {
			_normal_priority_btn.setSelected(true);
		} else if (priority.equals("low")) {
			_low_priority_btn.setSelected(true);
		} else if (priority.equals("normal")) {
			_normal_priority_btn.setSelected(true);
		} else if (priority.equals("high")) {
			_high_priority_btn.setSelected(true);
		}	


		_name.setText(_options.getFromName());
		_company.setText(_options.getFromCompany());
		_fax_number.setText(_options.getFromFaxNumber());
		_voice_number.setText(_options.getFromVoiceNumber());

		_notify_who.setText(_options.getNotifyWho());
		String when = _options.getNotifyWhen();
		if (when == null) {
			_onfailure_btn.setSelected(true);
		} else if (when.equals("on-failure")) {
			_onfailure_btn.setSelected(true);
		} else if (when.equals("on-success")) {
			_onsuccess_btn.setSelected(true);
		} else if (when.equals("always")) {
			_always_btn.setSelected(true);
		} else if (when.equals("never")) {
			_never_btn.setSelected(true);
		}	
	}



	public void save () {
		_options.save();
	}


	protected JDialog createDialog (Component parent) {

		if (_dialog != null) {
			return (_dialog);
		}

		Font f = getFont();
		Color fg = getForeground();
		Color bg = getBackground();

		_dialog = new JDialog(GuiUtils.getFrame(parent),
			"Fax Options", true);

		JPanel button_panel = new JPanel();
		button_panel.setBackground(bg);
		button_panel.setLayout (new FlowLayout(FlowLayout.RIGHT));
		JButton cancel = new JButton("Cancel");
		cancel.setBackground(bg);
		cancel.setForeground(fg);
		cancel.setFont(f);
		cancel.addActionListener(new CancelAction());
		button_panel.add(cancel);

		JButton ok = new JButton("OK");
		ok.setBackground(bg);
		ok.setForeground(fg);
		ok.setFont(f);
		ok.addActionListener(new OkAction());
		button_panel.add(ok);
		_dialog.getRootPane().setDefaultButton(ok);

		add(button_panel, BorderLayout.SOUTH);
		_dialog.getContentPane().add(this);
		_dialog.pack();

		return (_dialog);
	}


	public void showDialog (Component parent) {
		createDialog(parent);
		GuiUtils.centerDialog(_dialog, parent);
		_dialog.show();
	}


	public void setFont (Font f) {
		super.setFont(f);

		if (_priority_border == null) {
			return;
		}

		_priority_border.setTitleFont(f);
		_resolution_border.setTitleFont(f);
		_notification_border.setTitleFont(f);
		GuiUtils.setChildrenFont(this, _set_classes, f);
	}


	public void setBackground (Color c) {
		super.setBackground(c);

		if (_priority_border == null) {
			return;
		}

		GuiUtils.setChildrenBackground(this, _set_classes, c);
	}


	public void setForeground (Color c) {
		super.setForeground(c);

		if (_priority_border == null) {
			return;
		}

		_priority_border.setTitleColor(c);
		_resolution_border.setTitleColor(c);
		_notification_border.setTitleColor(c);
		GuiUtils.setChildrenForeground(this, _set_classes, c);
	}


	public synchronized String getServerUrl () {
		return (_options.getServerUrl());
	}


	public synchronized void setServerUrl (String url) {
		_options.setServerUrl(url);
		_server_url.setText(url);
	}


	public synchronized String getId () {
		return (_options.getId());
	}


	public synchronized void setId (String id) {
		_options.setId(id);
		_id.setText(id);
	}


	public synchronized String getSubid () {
		return (_options.getSubid());
	}


	public synchronized void setSubid (String subid) {
		_options.setSubid(subid);
		_subid.setText(subid);
	}


	public synchronized String getMailAddress () {
		return (_options.getMailAddress());
	}


	public synchronized void setMailAddress (String mail_address) {
		_options.setMailAddress(mail_address);
		_mail_address.setText(mail_address);
	}


	public synchronized String getResolution () {
		return (_options.getResolution());
	}


	public synchronized void setResolution (String resolution) {

		if (resolution == null) {
			return;
		} else if (resolution.equals("std")) {
			_std_btn.setSelected(true);
		} else if (resolution.equals("fine")) {
			_fine_btn.setSelected(true);
		}

		_options.setResolution(resolution);
	}


	public synchronized String getPriority () {
		return (_options.getPriority());
	}


	public synchronized void setPriority (String priority) {

		if (priority == null) {
			return;
		} else if (priority.equals("low")) {
			_low_priority_btn.setSelected(true);
		} else if (priority.equals("normal")) {
			_normal_priority_btn.setSelected(true);
		} else if (priority.equals("high")) {
			_high_priority_btn.setSelected(true);
		}

		_options.setPriority(priority);
	}


	public synchronized String getFromName () {
		return (_options.getFromName());
	}


	public synchronized void setFromName (String from_name) {
		_options.setFromName(from_name);
		_name.setText(from_name);
	}


	public synchronized String getFromCompany () {
		return (_options.getFromCompany());
	}


	public synchronized void setFromCompany (String from_company) {
		_options.setFromCompany(from_company);
		_company.setText(from_company);
	}


	public synchronized String getFromFaxNumber () {
		return (_options.getFromFaxNumber());
	}


	public synchronized void setFromFaxNumber (String fax_number) {
		_options.setFromFaxNumber(fax_number);
		_fax_number.setText(fax_number);
	}


	public synchronized String getFromVoiceNumber () {
		return (_options.getFromVoiceNumber());
	}


	public synchronized void setFromVoiceNumber (String voice_number) {
		_options.setFromVoiceNumber(voice_number);
		_voice_number.setText(voice_number);
	}


	public synchronized String getNotifyWhen () {
		return (_options.getNotifyWhen());
	}

	public synchronized void setNotifyWhen (String when) {

		_options.setNotifyWhen(when);
		if (when == null) {
			return;
		} else if (when.equals("on-failure")) {
			_onfailure_btn.setSelected(true);
		} else if (when.equals("on-success")) {
			_onsuccess_btn.setSelected(true);
		} else if (when.equals("always")) {
			_always_btn.setSelected(true);
		} else if (when.equals("never")) {
			_never_btn.setSelected(true);
		}
	}


	public synchronized String getNotifyWho () {
		return (_options.getNotifyWho());
	}


	public synchronized void setNotifyWho(String who) {
		_options.setNotifyWho(who);
		_notify_who.setText(who);
	}
}
