package com.vsi.xmlf.beans;


import com.vsi.xmlf.Account;
import com.vsi.xmlf.FaxNumber;
import com.vsi.xmlf.Sender;
import com.vsi.xmlf.VoiceNumber;

import java.io.IOException;


/**
  *
  */
public class FaxOptions extends Preferences {

	public FaxOptions (String filename) {
		super(filename);
		setDefaults();
	}


	public FaxOptions () {
		setDefaults();
	}


	protected void setDefaults () {

		/*
		 * Set the default preferences
		 */
		setDefault("server_url",      "localhost");
		setDefault("priority",        "normal");
		setDefault("resolution",      "fine");
		setDefault("id",	      "");
		setDefault("subid",           "");
		setDefault("mail-address",    "");
		setDefault("from-name",       "");
		setDefault("from-company",    "");
		setDefault("from-fax-number", "");
		setDefault("notify-when",     "on-failure");
		setDefault("notify-who",      "");
	}

	public void save () {
		try {
			super.save();
		} catch (IOException ignore) {
		}
	}


	public void setServerUrl (String url) {
		put("server_url", url);
	}

	public String getServerUrl () {
		return ((String)get("server_url"));
	}

	public void setId (String id) {
		put("id", id);
	}

	public String getId () {
		return ((String)get("id"));
	}

	public void setSubid (String subid) {
		put("subid", subid);
	}

	public String getSubid () {
		return ((String)get("subid"));
	}

	public void setMailAddress (String mail_address) {
		put("mail-address", mail_address);
	}

	public String getMailAddress () {
		return ((String)get("mail-address"));
	}


	public String getResolution () {
		return ((String)get("resolution"));
	}


	public void setResolution (String resolution) {
		put("resolution", resolution);
	}


	public String getPriority () {
		return ((String)get("priority"));
	}


	public void setPriority (String priority) {
		put("priority", priority);
	}


	public synchronized String getFromName () {
		return ((String)get("from-name"));
	}


	public synchronized void setFromName (String from_name) {
		put("from-name", from_name);
	}

		
	public synchronized String getFromCompany () {
		return ((String)get("from-company"));
	}

		
	public synchronized void setFromCompany (String from_company) {
		put("from-company", from_company);
	}


	public synchronized String getFromFaxNumber () {
		return ((String)get("from-fax-number"));
	}


	public synchronized void setFromFaxNumber (String fax_number) {
		put("from-fax-number", fax_number);
	}


	public synchronized String getFromVoiceNumber () {
		return ((String)get("from-voice-number"));
	}


	public synchronized void setFromVoiceNumber (String voice_number) {
		put("from-voice-number", voice_number);
	}


	public synchronized String getNotifyWhen() {
		return ((String)get("notify-when"));
	}


	public synchronized void setNotifyWhen (String notify_when) {
		put("notify-when", notify_when);
	}


	public synchronized String getNotifyWho() {
		return ((String)get("notify-who"));
	}


	public synchronized void setNotifyWho (String notify_who) {
		put("notify-who", notify_who);
	}


	public synchronized Sender getSender () {
		return (new Sender(getFromName(), getFromCompany(),
			new FaxNumber(getFromFaxNumber()),
			new VoiceNumber(getFromVoiceNumber())));
	}


	public synchronized Account getAccount () {
		return (new Account(getId(), getSubid(), getMailAddress()));
	}
}


