package com.vsi.xmlf;

/**
 * This class encapsulates the XML-F request-results element.
 *
 */
public 
class RequestResults implements XmlfObject, java.io.Serializable {

	protected String _message = null;
	protected String _status = null;

	protected String _tag = "request-results";


	/**
	 * No args constructor.
	 */
	public RequestResults () {
	}


	/**
	 *
	 */
	public RequestResults (String message, String status) {
		_message = message;
		_status  = status;
	}

	
	/**
	 *
	 */
	public synchronized boolean isNormal () {
		if (_status == null) {
			return (false);
		}

		if (_status.equalsIgnoreCase("normal")) {
			return (true);
		} else {
			return (false);
		}
	}


	/**
	 *
	 */
	public synchronized boolean isFailed () {
		if (_status == null) {
			return (false);
		}

		if (_status.equalsIgnoreCase("failed")) {
			return (true);
		} else {
			return (false);
		}
	}


	/**
	 *
	 */
	public RequestResults (XmlElement element) {
		setFromXml(element);
	}


	/**
	 * Returns true if the request results was a warning.
	 *
	 * @return true if the request results was a warning
	 */
	public synchronized boolean isWarning () {
		if (_status == null) {
			return (false);
		}

		if (_status.equalsIgnoreCase("warning")) {
			return (true);
		} else {
			return (false);
		}
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}

	
	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag());

		if (getStatus() != null) {
			xml.append(" status=\"" + getStatus() + "\"");
		}

		xml.append(">\n");

		if (getMessage() != null) {
			xml.append(indent + "\t" + getMessage() + "\n");
		}

		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  result_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement result_element) {

		setMessage(null);
		setStatus(null);

		if (result_element == null) {
			return;
		}

		setStatus(result_element.getAttribute("status"));
		setMessage(result_element.getData());
	}


	/**
	 * Gets the message associated with the request-results element.
	 */
	public synchronized String getMessage () {
		return (_message);
	}


	/**
	 * Sets the message associated with the request-results element.
	 *
	 * @param  message  the message for the request-results
	 */
	public synchronized void setMessage (String message) {
		_message = message;
	}


	/**
	 * Gets the status attribute associated with this
	 * request-results element.
	 */
	public synchronized String getStatus () {
		return (_status);
	}


	/**
	 * Sets the status attribute associated with the
	 * request-results element.
	 *
	 * @param  status  the status for the request-results
	 */
	public synchronized void setStatus (String status) {
		_status = status;
	}
}

