package com.vsi.xmlf;

import com.vsi.xmlf.AlreadyBoundException;
import com.vsi.xmlf.NotBoundException;

import java.util.Hashtable;

/**
 * The Registry class provides a simple mechanism for managing the
 * bindings of names to objects. Methods are provided for binding,
 * unbinding, looking up and listing name to object bindings.
 *
 */
public
class Registry extends Hashtable {

	/**
	 * Binds (maps) the specified name to the object. 
	 * A name may be bound to only one object at a time.
 	 *
	 * @param   name      the name of the object to bind.
	 * @param   obj       the object to bind.
	 * @exception com.vsi.xmlf.AlreadyBoundException if the object
	 * was already bound.
	 */
	public synchronized void bind (String name, Object obj) 
		throws AlreadyBoundException {

		if (contains(name)) {
		    	throw new AlreadyBoundException(
				"\"" + name.toString() + "\" is already bound");
		}

		put(name, obj);
	}



	/**
	 * Removes the specified name from the bindings. 
	 *
	 * @param   name   the name of the Object to unbind.
	 * @exception com.vsi.xmlf.NotBoundException if the object name
	 * has not been bound.
	 */
	public synchronized void unbind (String name) throws NotBoundException {

		if (remove(name) == null) {
			throw new NotBoundException(
				"\"" + name.toString() + "\" not bound");
		}
	}



	/**
	 * Returns the object bound to the specified name. If the 
	 * name is not bound, NULL will be returned.
	 *
	 * @param   name   the name of the binding to lookup.
	 * @exception com.vsi.xmlf.NotBoundException if the name
	 * has not been bound.
	 * @return  the object bount to the name
	 */
	public synchronized Object lookup (String name)
		throws NotBoundException {

		Object obj = get(name);
		if (obj== null) {
			throw new NotBoundException(
				name.toString() + " not bound");
		}

		return (obj);
	}



	/**
	 * Returns an array of the names in the registry. 
	 *
	 * @return an array of the names in the registry. 
	 */
	public String [] list () {

		int num_elements = size();
		if (num_elements < 1) {
			return (null);
		}

  		java.util.Enumeration list = keys();
		String names[] = new String[num_elements];
		int i = 0;
		while (list.hasMoreElements()) {
       	 		names[i++] = list.nextElement().toString();
		}

		return (names);
	}

}

