package com.vsi.xmlf;

/**
 * This class is used to decode a XML stream or data into a
 * <code>CancelResponse</code> object.
 *
 */
public 
class CancelResponseDecoder implements DocumentDecoder {

	public static final String DOC_TYPE = "fax-cancel-response";

	/**
	 * No args constructor.
	 */
	public CancelResponseDecoder () {
	}


	/**
	 * Create the appropriate XmlfObject for the XML document.
	 *
	 * @para  root_element  The root element for the XML document.
	 * @returns  A XmlfObject representing the XML document contained
	 * by root_element.
	 */
	public XmlfObject createObject (XmlElement root_element) {

		CancelResponse rsp = new CancelResponse();
		rsp.setFromXml(root_element);
		return (rsp);
	}



	/**
	 * Binds this decoder to the TransportManager
	 *
	 * @param  mgr  The TransportManager to bind the decoder to.
	 */
	public void bind (TransportManager mgr) {
		mgr.bindDecoder(DOC_TYPE, this);
	}
}

