package com.vsi.xmlf;

/**
 * This class is used to decode a XML stream or data into a
 * <code>CancelRequest</code> object.
 *
 */
public 
class CancelRequestDecoder implements DocumentDecoder {


	public static final String DOC_TYPE = "fax-cancel";

	/**
	 * No args constructor.
	 */
	public CancelRequestDecoder () {
	}


	/**
	 * Gets a <code>CancelRequest</code> object for the XML document
	 * decribed by the XML document.
	 *
	 * @param  root_element  a root XML element containg a cancel-request
	 * XML-F document.
	 * @return  a CancelRequest object based on root_element
	 */
	public XmlfObject createObject (XmlElement root_element) {

		CancelRequest request = new CancelRequest();
		request.setFromXml(root_element);
		return (request);
	}


	/**
	 * Binds this decoder to the TransportManager
	 *
	 * @param  mgr  The TransportManager to bind the decoder to.
	 */
	public void bind (TransportManager mgr) {
		mgr.bindDecoder(DOC_TYPE, this);
	}
}

