package com.vsi.xmlf;

/**
 *
 * This class encapsulates an XML-F account element.
 *
 */
public
class Account implements XmlfObject, java.io.Serializable {

	protected String _id = null;
	protected String _subid = null;
	protected String _mailaddress = null;

	protected String _tag = "account";



	/**
	 * No args constructor.
	 */
	public Account () {
	}


	/**
	 * Constructor for Account object which sets id, subid, and mailaddress.
	 *
	 * @param  id  the value for id
	 * @param  subid  the value for subid
	 * @param  mailaddress  the value for mailaddress
	 */
	public Account (String id, String subid, String mailaddress) {

		_id = id;
		_subid = subid;
		_mailaddress = mailaddress;
	}


	/**
	 * Constructor for Account object which sets only the id.
	 *
	 * @param  id  the value for id
	 */
	public Account (String id) {

		_id = id;
	}


	/**
	 * Creates an Account object initialized with the data from 
	 * account_element.
	 *
	 * @param  accoun_element  the XML element containing the account info
	 */
	public Account (XmlElement account_element) {
		setFromXml(account_element);
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag() + ">\n");

		if (getId() != null) {
			xml.append(indent + "\t<id>" + getId() +"</id>\n");
		}

		if (getSubid() != null) {
			xml.append(indent + "\t<subid>" + 
				getSubid() + "</subid>\n");
		}

		if (getMailAddress() != null) {
			xml.append(indent + "\t<mail-address>" +
				getMailAddress() + "</mail-address>\n");
		}

		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  account_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement account_element) {

		setId(null);
		setSubid(null);
		setMailAddress(null);

		if (account_element == null) {
			return;
		}

		XmlElement xml[] = account_element.getSubElements();
		setId(XmlElement.getData(xml, "id"));
		setSubid(XmlElement.getData(xml, "subid"));
		setMailAddress(XmlElement.getData(xml, "mail-address"));
	}



	/**
	 * Gets the identification assigned to the Account object.
	 *
	 * @return  the id for the account
	 */
	public String getId () {
		return (_id);
	}


	/**
	 * Gets the email address assigned to the Account object.
	 *
	 * @return  the email address for the account
	 */
	public String getMailAddress () {
		return (_mailaddress);
	}


	/**
	 * Gets the sub-id assigned to the Account object.
	 *
	 * @return  the sub-id for the account
	 */
	public String getSubid () {
		return (_subid);
	}


	/**
	 * Assigns id as the identification for the Account object.
	 *
	 * @param  id  the value to assign to the id.
	 */
	public void setId (String id) {
		_id = id;
	}


	/**
	 * Assigns email_address as the email address of the Account object.
	 *
	 * @param  mailaddress  the value to assign to the mail address.
	 */
	public void setMailAddress (String mailaddress) {
		_mailaddress = mailaddress;
	}


	/**
	 * Assigns subid as the sub-id of the Account object.
	 *
	 * @param  subid  the value to assign to the subid.
	 */
	public void setSubid (String subid) {
		_subid = subid;
	}
}

