#!/bin/sh
#
#+++FHDR+++
#
#	Description:
#
#	process all licenses
#
#---FHDR---

# ------------------------------------------------------------------------
# check if running in windows
#
in_windows ()
{
	[ -d "c:/" ]
}

# ------------------------------------------------------------------------
# get name of the console device
#
get_dev_tty ()
{
	if in_windows
	then
		echo "con:"
	else
		echo "/dev/tty"
	fi
}

# ------------------------------------------------------------------------
# read user input from a response file or the keyboard & save the response
#
read_user_input ()
{
	id="$1"
	found=no

	CONSOLE=`get_dev_tty`

	if [ "$id" = "" -o "$LOAD_RESPONSE_FILE" = "" ]
	then
		read response <$CONSOLE
	else
		response=`grep "^$id:" "$LOAD_RESPONSE_FILE"`
		if [ $? -eq 0 ]
		then
			response=`echo "$response" | sed -e 's/^[^:]*://'`
			echo "$response" >&2
			found=yes
		else
			read response <$CONSOLE
		fi
	fi

	if [ "$found" = "no" -a "$id" != "" -a "$SAVE_RESPONSE_FILE" != "" ]
	then
		sed -e "/^$id:/d" "$SAVE_RESPONSE_FILE" >"$SAVE_RESPONSE_FILE.tmp"
		echo "$id:$response" |
			cat "$SAVE_RESPONSE_FILE.tmp" - >"$SAVE_RESPONSE_FILE"
		rm -f "$SAVE_RESPONSE_FILE.tmp"
	fi

	echo "$response"
}

# ------------------------------------------------------------------------
# check if running in BSD
#
in_bsd ()
{
	[ \( -f /vmunix -a ! -f /osf_boot \) -o \
		-f /netbsd -o \
		-f /kernel -o \
		-f /mach_kernel -o \
		`uname -s` = "FreeBSD" -o \
		`uname -s` = "OpenBSD" -o \
		`uname -s` = "NetBSD" ]
}

# ------------------------------------------------------------------------
# check if running in linux
#
in_linux ()
{
	[ -f /etc/lilo.conf -o `uname -s` = "Linux" ]
}

# ------------------------------------------------------------------------
# echo a line without a final CR
#
echonl ()
{
	if in_linux
	then
		# --------------------------------------------------------
		# Linux
		#
		/bin/echo -e "${*}\c"

	elif in_bsd
	then
		# --------------------------------------------------------
		# BSD
		#
		echo -n "${*}"

	else
		# --------------------------------------------------------
		# System V
		#
		echo "${*}\c"
	fi
}

# ------------------------------------------------------------------------
# getyesorno() -- this prompts the user to hit Yes or No, and it returns
# true if the user hits yes, false if the user hits no, and it loops if
# the user hits something else.
#
getyesorno ()
{
	default=y
	if [ x"$1" = x"-y" ]
	then
		default=y
		shift
	elif [ x"$1" = x"-n" ]
	then
		default=n
		shift
	fi

	id="$1"
	shift

	while true
	do
		echonl "$@ (y/n) [$default] : "
		answer=`read_user_input "$id"`

		if [ "$answer" = "" ]
		then
			answer=$default
		fi

		case "$answer" in

		[yY]*)
			return 0
			;;

		[nN]*)
			return 1
			;;
		esac
	done
}

# ------------------------------------------------------------------------
# wait for a CR to continue
#
wait_return ()
{
	echonl "Please press RETURN to continue "
	dummy=`read_user_input`
}

# ------------------------------------------------------------------------
# main()
#
# note: we are using the vfxadmin which has not been installed yet
#
if in_windows
then
	PATH="./bin;$PATH" export PATH
else
	PATH="./bin:$PATH" export PATH
fi

NEED_WAIT=no

# ------------------------------------------------------------------------
# Display license agreement if needed.
#
if [ "$QUICK_INSTALL" != "yes" -a ! -f "$VSIFAX/lib/license.txt" ]
then
	../install/eula || exit 1
fi

# ------------------------------------------------------------------------
# Initialize license file if needed.
#
vfxadmin license -is

# ------------------------------------------------------------------------
# Ask for server license
#

vfxadmin license -D -s

if [ $? -eq 0 ]
then
	HAVE_SERVER_LIC=yes
else

	echo ""
	echo "Please enter your server license information."

	echo ""
	echo "Enter below your serial number and your activation key. If you do not enter"
	echo "any server license information, an evaluation license (limited to 30 days)"
	echo "will be used."
	echo ""
	echo "If you are installing an imaging server, enter the serial number and"
	echo "activation key from the 'Imaging Server Setup and Configuration' section"
	echo "of the VSI-FAX Installation and Administration Guide."
	echo ""


	if getyesorno -y "" "Do you want to enter a license now?"
	then
		vfxadmin license

		if [ $? -eq 0 ]
		then
			HAVE_SERVER_LIC=yes
		else
			HAVE_SERVER_LIC=no

			echo ""
			echo "You did not enter a valid server license."
		fi
	else
		HAVE_SERVER_LIC=no
	fi

	if [ "$HAVE_SERVER_LIC" = "no" ]
	then
		if [ -f "./lib/eval.txt" ]
		then
			vfxadmin license -s -L `cat ./lib/eval.txt`

			if [ $? -eq 0 ]
			then
				HAVE_SERVER_LIC=yes
			else
				echo "An error occured while installing evaluation license"
			fi
		else
			echo "No valid evaluation license found"
		fi

		if [ "$HAVE_SERVER_LIC" = "no" ]
		then
			echo "Without a valid server license, the server will only run"
			echo "in DEMO mode (no modems will be started)."
			getyesorno -n "no-server-cont" \
				"Do you want to continue with the install? " ||
				exit 1
		fi
	fi
fi

if [ -f "./lib/eval.txt" ]
then
	rm -f ./lib/eval.txt
fi

if [ "$QUICK_INSTALL" != "yes" ]
then
	echo "************************************************************"
	echo "* License may be modified after this installation via the  *"
	echo "* \"vfxadmin license\" command-line utility or the MMC FAX   *"
	echo "* Server Administration plugin.                            *"
	echo "************************************************************"
fi

[ "$NEED_WAIT" = "yes" ] && { echo ""; wait_return; }


# ------------------------------------------------------------------------
# check if a Fax on Demand Connector needs to be uninstalled from VSI-FAX 5.1
#
FODC_UNINSTALL="$VSIFAX/lbin/vsi-fodc-uninstall.sh"
[ -x $FODC_UNINSTALL ] && $FODC_UNINSTALL -f



exit 0
