# +++PHDR+++
#
# Procedure:	vsimenu__BuildMainForm
#
# Description:	Draws the main form for the vsimenu admin interface
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# form_shell            Pathname for toplevel shell
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__BuildMainForm { form_shell } {
	global vsimenu__default vsimenu__shell pixmap tcl_platform
	global tk_strictMotif
	global state
	global vsimenu__hostname
	global vsimenu__isadmin

	set vsimenu__hostname [ vcl hostname ]
	set vsimenu__isadmin  [ vcl isadmin  ]

	set state [ vcl scheduler isstopped ]

	set tk_strictMotif 1

	#
	# Create the top level shell if the form_shell is not "."
	#
	if { $form_shell == "." } {
		set form ".frame"
		set vsimenu__shell ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $form_shell }
		toplevel $form_shell
		set form $form_shell
		set vsimenu__shell $form_shell
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - Administration"
	wm title $form_shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form_shell WM_DELETE_WINDOW vsimenu__Done

	#
	# Create the bitmaps to use for the buttons
	#
	set pixmap(done)     [ vclutils__LoadPixmap done_xpm     exit.xpm ]
	set pixmap(user)     [ vclutils__LoadPixmap user_xpm     users.xpm ]
	set pixmap(modem)    [ vclutils__LoadPixmap modem_xpm    modem.xpm ]
	set pixmap(co)       [ vclutils__LoadPixmap company_xpm  company.xpm ]
	set pixmap(sysparam) [ vclutils__LoadPixmap sysparam_xpm sysparam.xpm ]
	set pixmap(license)  [ vclutils__LoadPixmap license_xpm  license.xpm ]
	set pixmap(start)    [ vclutils__LoadPixmap start_xpm    start.xpm ]
	set pixmap(slow)     [ vclutils__LoadPixmap slow_xpm     slow.xpm ]
	set pixmap(stop)     [ vclutils__LoadPixmap stop_xpm     stop.xpm ]

	if { $pixmap(user) == "" } {
		 button $form.user_button -text "User" -width 8 \
			-command vsimenu__User
	} else {
		button $form.user_button -image $pixmap(user) -width 32 \
			-command vsimenu__User
	}
	grid $form.user_button -row 0 -column 0
	label $form.user_label -text "User Administration"
	grid $form.user_label -row 0 -column 1 -sticky w
	
	if { $pixmap(modem) == "" } {
		 button $form.modem_button -text "Device" -width 8 \
			-command vsimenu__Modem
	} else {
		button $form.modem_button -image $pixmap(modem) -width 32 \
			-command vsimenu__Modem
	}
	grid $form.modem_button -row 1 -column 0
	label $form.modem_label -text "Device Administration"
	grid $form.modem_label -row 1 -column 1 -sticky w

	if { $pixmap(sysparam) == "" } {
		 button $form.sysparam_button -text "Params" -width 8 \
			-command vsimenu__System
	} else {
		button $form.sysparam_button -image $pixmap(sysparam) \
			-width 32 -command vsimenu__System
	}
	grid $form.sysparam_button -row 2 -column 0
	label $form.sysparam_label -text "System Parameters"
	grid $form.sysparam_label -row 2 -column 1 -sticky w
	
	if { $pixmap(co) == "" } {
		 button $form.co_button -text "Company" -width 8 \
			-command vsimenu__CompanyInfo
	} else {
		button $form.co_button -image $pixmap(co) -width 32 \
			-command vsimenu__CompanyInfo
	}
	grid $form.co_button -row 3 -column 0
	label $form.co_label -text "Company Information"
	grid $form.co_label -row 3 -column 1 -sticky w
	
	if { $pixmap(license) == "" } {
		 button $form.license_button -text "License" -width 8 \
			-command vsimenu__License
	} else {
		button $form.license_button -image $pixmap(license) \
			-width 32 -command vsimenu__License
	}
	grid $form.license_button -row 4 -column 0
	label $form.license_label -text "License Management"
	grid $form.license_label -row 4 -column 1 -sticky w
	
	if { $state } {

		if { $pixmap(start) == "" } {
		 	button $form.start_button -text "Start" -width 8 \
				-command vsimenu__StartMenu
		} else {
			button $form.start_button -image $pixmap(start) \
				-width 32 -command vsimenu__StartMenu
		}
		grid $form.start_button -row 5 -column 0
		label $form.start_label -text "Start the server"
		grid $form.start_label -row 5 -column 1 -sticky w

	} else {
		if { $pixmap(stop) == "" } {
		 	button $form.start_button -text "Stop" -width 8 \
				-command vsimenu__StopMenu
		} else {
			button $form.start_button -image $pixmap(stop) \
				-width 32 -command vsimenu__StopMenu
		}
		grid $form.start_button -row 5 -column 0
		label $form.start_label -text "Stop the server"
		grid $form.start_label -row 5 -column 1 -sticky w
	}

	if { $pixmap(done) == "" } {
		 button $form.done_button -text "Exit" -width 8 \
			-command vsimenu__Done
	} else {
		button $form.done_button -image $pixmap(done) -width 32 \
			-command vsimenu__Done
	}
	grid $form.done_button -row 6 -column 0
	label $form.done_label -text "Exit VSI-FAX Administration"
	grid $form.done_label -row 6 -column 1 -sticky w
	
	update idletasks
	catch { pack $form -padx 32 -pady 16 }
	update idletasks

	vclutils__LockSize .
	return
}


# +++PHDR+++
#
# Procedure:	vsimenu__User
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__User {} {
	global vsimenu__shell
	vclutils__LoadSource user_adm__Popup useradm.tcl
	catch { user_adm__Popup ${vsimenu__shell} .user_adm }
}


# +++PHDR+++
#
# Procedure:	vsimenu__Modem
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__Modem {} {
	global vsimenu__shell
	vclutils__LoadSource modem_adm__Popup modemadm.tcl
	catch { modem_adm__Popup ${vsimenu__shell} .modem_adm }
}


# +++PHDR+++
#
# Procedure:	 vsimenu__CompanyInfo
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__CompanyInfo {} {
	global vsimenu__shell
	vclutils__LoadSource company_info__Popup coinfo.tcl
	catch { company_info__Popup ${vsimenu__shell} .company_info "" }
}


# +++PHDR+++
#
# Procedure:	vsimenu__System
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__System {} {
	global vsimenu__shell
	vclutils__LoadSource system_params__Popup sysparam.tcl
	catch { system_params__Popup ${vsimenu__shell} .system_params }
}


# +++PHDR+++
#
# Procedure:	vsimenu__License
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__License {} {
	global vsimenu__shell

	vclutils__LoadSource license_adm__Popup licadm.tcl
	catch { license_adm__Popup ${vsimenu__shell} .license_adm }
}

proc vsimenu__StartMenu { } {
	global vsimenu__shell
	global env
	global state
	global pixmap

	if { $pixmap(slow) != "" } {
		${vsimenu__shell}.start_button configure \
			-image $pixmap(slow) \
			-width 32 -command vsimenu__StopMenu
	}

	vsimenu__Start ${vsimenu__shell}.start_label

	if { $pixmap(stop) == "" } {
	 	${vsimenu__shell}.start_button configure \
			-text "Stop" -width 8 \
			-command vsimenu__StopMenu
	} else {
		${vsimenu__shell}.start_button configure \
			-image $pixmap(stop) \
			-width 32 -command vsimenu__StopMenu
	}
	${vsimenu__shell}.start_label  configure -text  "Stop the server"
}

proc vsimenu__Start { status_line } {
	global vsimenu__shell
	global env
	global state


	#
	# Start the scheduler
	#
	set text "Starting the server"
	$status_line configure -text $text
	update
	catch { vcl scheduler start }
	update
	after 500
	
	#
	# Wait for the scheduler to startup
	#
	for { set i 0 } { $i < 10 } { incr i } {
		set state [ vcl scheduler isrunning ]
		if { $state } {
			break
		}

		update
		after 500
		set text1 "$text."
		set text $text1
		$status_line configure -text $text	
		update
		after 500
	}


	$status_line configure -text ""
}

proc vsimenu__StopMenu { } {
	global vsimenu__shell
	global env
	global state
	global pixmap

	if { $pixmap(slow) != "" } {
		${vsimenu__shell}.start_button configure \
			-image $pixmap(slow) \
			-width 32 -command vsimenu__StartMenu
	}

	vsimenu__Stop ${vsimenu__shell}.start_label

	if { $pixmap(start) == "" } {
	 	${vsimenu__shell}.start_button configure \
			-text "Start" -width 8 \
			-command vsimenu__StartMenu
	} else {
		${vsimenu__shell}.start_button configure \
			-image $pixmap(start) \
			-width 32 -command vsimenu__StartMenu
	}
	${vsimenu__shell}.start_label  configure -text  "Start the server"
}

proc vsimenu__Stop { status_line } {
	global vsimenu__shell
	global env
	global state

	if { [vcl scheduler isrunning] } {

		set text "Stopping the server"
		$status_line configure -text $text
		update
		
		vcl scheduler stop
		update
	
		#
		# Wait for the scheduler to shut down
		#
		for { set i 0 } { $i < 10 } { incr i } {
			set state [ vcl scheduler isstopped ]
			if { $state } {
				break
			}

			after 500
			update
			after 500
			set text1 "$text."
			set text $text1
			$status_line configure -text $text	
			update
		}
	}
}


# +++PHDR+++
#
# Procedure:	vsimenu__Done
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc vsimenu__Done {} {
	global vsimenu__shell

	catch { vcl destroy @vsimenu }

	if { ${vsimenu__shell} == ".vsimenu" } {
		catch { destroy ${vsimenu__shell} }
	} else {
		exit
	}
}


# +++PHDR+++
#
# Procedure:	Help
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc Help {} {
	global argv0

	puts "Usage: [ file tail $argv0 ]"
}


# +++PHDR+++
#
# Procedure:	InvalidOption
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc InvalidOption { opt } {
	global argv0

	puts "[ file tail $argv0 ]: invalid option -- $opt"
	puts "Type \"[ file tail $argv0 ] -help\" for help"
}


# +++PHDR+++
#
# Procedure:	main entry point
#
# Description:	This is the entry point to popup the vsimenu interface
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

global argv0 argv argc

#
# Check the command line
#
if { $argc > 0 } {
	foreach opt $argv {
		switch -exact -- $opt {

			"-V" 	   { 
					puts "vsimenu: version [ vcl version ]"
					exit 0 
				   }

			"-?" 	   { Help ; exit 0 }
			"-??" 	   { Help ; exit 0 }
			"-help"    { Help ; exit 0 }
			"-helpall" { Help ; exit 0 }

			default { InvalidOption $opt ; exit 1 }
		}
	}
}


#
# Decide what toplevel shell to use
#
set vsimenu_shell "."


#
# Build and display the Modem database form
#
vsimenu__BuildMainForm $vsimenu_shell

