# +++PHDR+++
#
# Procedure:	user_adm__BuildMainForm
#
# Description:	Draws the main form for the user database editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# form_shell		Pathname of toplevel shell for interface.
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__BuildMainForm { form_shell } {
	global user_adm__default user_adm__shell
	global vsimenu__hostname
	global vsimenu__isadmin

	if { $vsimenu__isadmin } {
		set state "normal"
		set double_click user_adm__Edit
	} else {
		set state "disabled"
		set double_click ""
	}

	#
	# Create the top level shell if the form_shell is not "."
	#
	if { $form_shell == "." } {
		set form ".frame"
		set user_adm__shell ".frame"
		catch { destroy $form }
		frame $form
	} else {
        	catch { destroy $form_shell }
		toplevel $form_shell
		set form $form_shell
		set user_adm__shell $form_shell
	}

	#
	# Put the title on the shell
	#
	set vtitle "$vsimenu__hostname - User Administration"
	wm title $form_shell $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form_shell WM_DELETE_WINDOW user_adm__Done
	
	#
	# Build scrolled lists that hold the user id, user name, user type,
	# and licensed flag
	#
	frame $form.lists -highlightthickness 2
	frame $form.lists.id
	label $form.lists.id.label -text "ID" 
	listbox $form.lists.id.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 8 \
		-yscrollcommand [ list $form.lists.lic.scroll set ] \
		-highlightthickness 0
	pack $form.lists.id.label 
	pack $form.lists.id.list -side left
	pack $form.lists.id -side left

	frame $form.lists.name
	label $form.lists.name.label -text "Name"
	listbox $form.lists.name.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 24 -takefocus 0 \
		-yscrollcommand [ list $form.lists.lic.scroll set ] \
		-highlightthickness 0
	pack $form.lists.name.label 
	pack $form.lists.name.list -side left
	pack $form.lists.name -side left

	frame $form.lists.type
	label $form.lists.type.label -text "Type"
	listbox $form.lists.type.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 10 -takefocus 0 \
		-yscrollcommand [ list $form.lists.lic.scroll set ] \
		-highlightthickness 0
	pack $form.lists.type.label 
	pack $form.lists.type.list -side left
	pack $form.lists.type -side left

	frame $form.lists.lic
	label $form.lists.lic.label -text "License"
	listbox $form.lists.lic.list -borderwidth 1 -exportselection false \
		-relief sunken -selectmode browse -width 6 -takefocus 0 \
		-yscrollcommand [ list $form.lists.lic.scroll set ] \
		-highlightthickness 0
	pack $form.lists.lic.label 
	pack $form.lists.lic.list -side left
	pack $form.lists.lic -side left

	#
	# Add a scrollbar to the lists
	#
	scrollbar $form.lists.lic.scroll -takefocus 0 -highlightthickness 0
	pack $form.lists.lic.scroll -side left -fill y
	pack $form.lists -pady 16 -padx 16

	#
	# Bind the lists so they act together
	#
	vclutils__BindMultiScrollbar $form.lists.lic.scroll \
		$form.lists.id.list $form.lists.name.list \
		 $form.lists.type.list $form.lists.lic.list

	vclutils__BindMultiList $double_click $form.lists.id.list \
		$form.lists.name.list $form.lists.type.list \
		$form.lists.lic.list

	
	frame $form.buttons
	button $form.buttons.done -width 6 -text Done \
		-command { user_adm__Done }
	button $form.buttons.edit -width 6 -text Edit -state $state \
		-command { user_adm__Edit }
	button $form.buttons.new -width 6 -text "New" -state $state \
		-command { user_adm__New }
	button $form.buttons.delete -width 6 -text Delete -state $state \
		-command { user_adm__Delete }

	pack $form.buttons.done $form.buttons.edit $form.buttons.new \
		$form.buttons.delete -side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -pady 16

	catch { pack $form }
	return
}


# +++PHDR+++
#
# Procedure:	user_adm__FillList
#
# Description:	Fills in the multi-column list of users.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__FillList { } {
	global user_adm__shell

	#
	# Clear the current lists and default combobox
	#
	${user_adm__shell}.lists.id.list delete 0 end
	${user_adm__shell}.lists.name.list delete 0 end
	${user_adm__shell}.lists.type.list delete 0 end
	${user_adm__shell}.lists.lic.list delete 0 end

	#
	# Get a list of users and fill in the lists
	#
	foreach user [ @user_adm list ] {
		@user_adm list $user -array rec
		${user_adm__shell}.lists.id.list insert end $rec(cli)
		${user_adm__shell}.lists.name.list insert end $rec(usr)

		if { $rec(utp) == "usr-dept" } {
			${user_adm__shell}.lists.type.list insert end "dept"
		} else {
			${user_adm__shell}.lists.type.list \
				insert end "individual"
		}

		if { $rec(lic) == "true" } {
			${user_adm__shell}.lists.lic.list insert end "yes"
		} else {
			${user_adm__shell}.lists.lic.list insert end "no"
		}
	}
}


# +++PHDR+++
#
# Procedure:	user_adm__Delete
#
# Description:	"Delete" command proc. 
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__Delete {} {
	global user_adm__shell

	#
	# Get the selected destination
	#
	set selected [vclutils__GetSelected ${user_adm__shell}.lists.id.list]
	if { $selected == "" } { 
		return 
	}

	set result [ tk_dialog .dlg "Delete User" \
		"Do you really wish\nto delete \"$selected\"?" \
		question 1 "Yes" "No" ]

	if { $result == 1 } { 
		return 
	}

	#
	# Delete the selected item and update the list
	#
	@user_adm delete $selected
	user_adm__FillList
}



# +++PHDR+++
#
# Procedure:	user_adm__Done
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc user_adm__Done {} {
	global user_adm__done 
	set user_adm__done 1
}


# +++PHDR+++
#
# Procedure:	user_adm__Edit
#
# Description:	"Edit" command proc. Displays the edit form with the 
#               selected user loaded.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__Edit {} {
	global user_adm__shell user_adm__rec user_adm__editdone 
	global user_adm__saved_rec user_adm__selected

	set user_adm__selected [vclutils__GetSelected \
		${user_adm__shell}.lists.id.list]

	#
	# Make sure a user is selected
	#
	if { ${user_adm__selected} == "" } {
		return
	}

	#
	# Build and fill the form
	#
	@user_adm list ${user_adm__selected} -array user_adm__rec
	user_adm__BuildEditForm
	vclutils__CenterDialog .useredit_shell ${user_adm__shell}
	vclutils__LockSize .useredit_shell
	

	array set user_adm__saved_rec [array get user_adm__rec]
	set user_adm__confirm ""

	#
	# Always update afetr poping up and before setting focus
	#
	grab .useredit_shell
	update
	focus .useredit_shell.user.name.entry

	#
	# Make the dialog modal
	#
	tkwait variable user_adm__editdone
	grab release .useredit_shell
	destroy .useredit_shell


	if { ${user_adm__editdone} } {
		set index [${user_adm__shell}.lists.id.list curselection]

		${user_adm__shell}.lists.id.list delete $index
		${user_adm__shell}.lists.name.list delete $index
		${user_adm__shell}.lists.type.list delete $index
		${user_adm__shell}.lists.lic.list delete $index

		@user_adm list ${user_adm__selected} -array rec
		${user_adm__shell}.lists.id.list insert $index $rec(cli)
		${user_adm__shell}.lists.name.list insert $index $rec(usr)

		if { $rec(utp) == "usr-dept" } {
			${user_adm__shell}.lists.type.list insert $index "dept"
		} else {
			${user_adm__shell}.lists.type.list \
				insert $index "individual"
		}

		if { $rec(lic) == "true" } {
			${user_adm__shell}.lists.lic.list insert $index "yes"
		} else {
			${user_adm__shell}.lists.lic.list insert $index "no"
		}

		vclutils__SetSelected $index ${user_adm__shell}.lists.id.list \
			${user_adm__shell}.lists.name.list \
			${user_adm__shell}.lists.type.list \
			${user_adm__shell}.lists.lic.list
	}
}




# +++PHDR+++
#
# Procedure:	user_adm__New
#
# Description:	Callback for the "New" button
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__New {} {
	global user_adm__rec user_adm__saved_rec user_adm__selected \
		user_adm__confirm user_adm__editdone user_adm__shell

	set user_adm__rec(cli) ""
	set user_adm__rec(usr) ""
	set user_adm__rec(utp) usr-ind
	set user_adm__rec(umd) usr-reg
	set user_adm__rec(pri) ""
	set user_adm__rec(lic) true
	set user_adm__rec(pwd) ""
	set user_adm__rec(did) ""
	set user_adm__rec(autodel)   off
	set user_adm__rec(automail)  off
	set user_adm__rec(autoprint) off
	set user_adm__rec(autosprt)  off
	set user_adm__rec(confirm)   off
	set user_adm__rec(mailaddr)  ""
	set user_adm__rec(prtstr)    ""
	set user_adm__rec(sprtstr)   ""
	set user_adm__confirm  ""
	array set user_adm__saved_rec [array get user_adm__rec]
	set user_adm__selected ""
	set user_adm__confirm ""

	user_adm__BuildEditForm
	vclutils__CenterDialog .useredit_shell ${user_adm__shell}
	vclutils__LockSize .useredit_shell



	#
	# Make the dialog modal
	#
	update
	grab .useredit_shell

	.useredit_shell.user.id.entry configure    -state normal
#	.useredit_shell.pw.enter.entry configure   -state normal
#	.useredit_shell.pw.confirm.entry configure -state normal
	focus .useredit_shell.user.id.entry

	tkwait variable user_adm__editdone
	grab release .useredit_shell
	destroy .useredit_shell


	if { ${user_adm__editdone} } {
		
		#
		# Update the user list and select this new user
		#
		user_adm__FillList
	}
}


# +++PHDR+++
#
# Procedure:	user_adm__BuildEditForm
#
# Description:	This procedure builds the VdbUser database edit form
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__BuildEditForm { } {
	global user_adm__confirm user_adm__rec
	global vsimenu__hostname

	#
	# Create the top level shell if the form_shell is not "."
	#
	set form .useredit_shell
        catch { destroy $form }
	toplevel $form

	set vtitle "$vsimenu__hostname - User Editor"
	wm title $form $vtitle

	#
	# Setup a handler for the window manager "Close" function
	#
	wm protocol $form WM_DELETE_WINDOW user_adm__Cancel


	#
	# Build the User ID and Name fields
	#
	frame $form.user
	frame $form.user.id
	label $form.user.id.label -text "User ID:" -width 18 -anchor e
	entry $form.user.id.entry -relief sunken  \
		-width 24 -textvariable user_adm__rec(cli)
	pack $form.user.id.label $form.user.id.entry -side left
	pack $form.user.id -ipady 4
	
	frame $form.user.name
	label $form.user.name.label -text "User name:" -width 18 -anchor e
	entry $form.user.name.entry -relief sunken \
		-width 24 -textvariable user_adm__rec(usr)
	pack $form.user.name.label $form.user.name.entry -side left
	pack $form.user.name

	pack $form.user -pady 4 -padx 16


	#
	# Build the Password fields
	#
#	frame $form.pw
#	frame $form.pw.enter
#	label $form.pw.enter.label -text "Password:" -width 18 -anchor e
#	entry $form.pw.enter.entry -relief sunken  \
#		-width 24 -textvariable user_adm__rec(pwd) -show "*"
#	pack $form.pw.enter.label $form.pw.enter.entry -side left
#	pack $form.pw.enter -ipady 4
# 
#	frame $form.pw.confirm
#	label $form.pw.confirm.label -text "Re-Enter password:" \
#		-width 18 -anchor e
#	set user_adm__confirm ""
#	entry $form.pw.confirm.entry -relief sunken  \
#		-width 24 -textvariable user_adm__confirm -show "*"
#	pack $form.pw.confirm.label $form.pw.confirm.entry -side left
#	pack $form.pw.confirm
# 
#	pack $form.pw -padx 16
 

	#
	# Build the DID extension field
	#
	frame $form.did
	label $form.did.label -text "DID extension:" -width 18 -anchor e
	entry $form.did.entry -width 24 -textvariable user_adm__rec(did)
	pack $form.did.label $form.did.entry -side left
	pack $form.did -padx 16


	#
	# Build the Client Type radio buttons
	#
	frame $form.type
	label $form.type.label -text "Client Type:" \
		-anchor e -width 13 -justify right
	radiobutton $form.type.user -text Individual \
		-var user_adm__rec(utp) -value usr-ind 
	radiobutton $form.type.dept -text Department \
		-var user_adm__rec(utp) -value usr-dept
	pack $form.type.label $form.type.user $form.type.dept \
		-side left -ipadx 4
	pack $form.type -side top -anchor w -padx 16 -ipady 8

	
	#
	# Build the Client Mode radio buttons
	#
	frame $form.mode
	label $form.mode.label -text "Client Mode:" \
		-anchor e -width 13 -justify right
	radiobutton $form.mode.reg -text User \
		-var user_adm__rec(umd) -value usr-reg 
	radiobutton $form.mode.admin -text Admin \
		-var user_adm__rec(umd) -value usr-admin
	pack $form.mode.label $form.mode.reg $form.mode.admin \
		-side left -ipadx 4
	pack $form.mode -side top -anchor w -padx 16

	
	#
	# Build the Max Priority radio buttons
	#
	frame $form.priority
	label $form.priority.label -text "Max Priority:" \
		-anchor e -width 13 -justify right
	radiobutton $form.priority.none -text None \
		-var user_adm__rec(pri) -value ""
	radiobutton $form.priority.low -text Low \
		-var user_adm__rec(pri) -value "l"
	radiobutton $form.priority.med -text Medium \
		-var user_adm__rec(pri) -value "m"
	radiobutton $form.priority.high -text High \
		-var user_adm__rec(pri) -value "h"
	radiobutton $form.priority.urgent -text Urgent \
		-var user_adm__rec(pri) -value "u"
	pack $form.priority.label $form.priority.none $form.priority.low \
		$form.priority.med $form.priority.high $form.priority.urgent \
		-side left -ipadx 4
	pack $form.priority -side top -anchor w -padx 16 -pady 8

	#
	# Build the License radio buttons
	#
	frame $form.license
	label $form.license.label -text "Licensed:" \
		-anchor e -width 13 -justify right
	radiobutton $form.license.yes -width 3 -text Yes \
		-var user_adm__rec(lic) -value true
	radiobutton $form.license.no -width 3 -text No \
		-var user_adm__rec(lic) -value false
	pack $form.license.label $form.license.yes $form.license.no \
		-side left -ipadx 4
	pack $form.license -side top -anchor w -padx 16


	#
	# outbound Fax Processing 
	#
	frame $form.spacero
	pack $form.spacero -pady 8

	frame $form.separatoro -relief groove -borderwidth 1 -height 2
	pack $form.separatoro -padx 2 -fill x

	frame $form.outbound
	label $form.outbound.label -text "Outbound Processing" \
		-anchor w -justify left
	pack $form.outbound.label -side top -anchor w -pady 8

	frame $form.outbound.sprint
	checkbutton $form.outbound.sprint.button -text "Print sent faxes" \
		-anchor w \
		-justify left -width 16 -var user_adm__rec(autosprt) \
		-onvalue "true" -offvalue "false"
	ComboBox $form.outbound.sprint.entry -ewidth 22 -strict 1 \
		-lbltext "Printer " -lblwidth 8 \
		-listwidth 22 -textvariable user_adm__rec(sprtstr)
	pack $form.outbound.sprint.button $form.outbound.sprint.entry \
		-side left
	pack $form.outbound.sprint -side top -anchor w

	checkbutton $form.outbound.confirm -var user_adm__rec(confirm) \
	    -anchor w -justify left -onvalue "true" -offvalue "false" \
	    -text "Print confirmation of send"
	pack $form.outbound.confirm -side top -anchor w

	pack $form.outbound -side top -fill x -padx 12

	#
	# inbound Fax Processing 
	#
	frame $form.spaceri
	pack $form.spaceri -pady 8

	frame $form.separatori -relief groove -borderwidth 1 -height 2
	pack $form.separatori -padx 2 -fill x

	frame $form.inbound
	label $form.inbound.label -text "Inbound Processing" \
		-anchor w -justify left
	pack $form.inbound.label -side top -anchor w -pady 8

	frame $form.inbound.print
	checkbutton $form.inbound.print.button -text "Print rcvd faxes" \
		-anchor w \
		-justify left -width 16 -var user_adm__rec(autoprint) \
		-onvalue "true" -offvalue "false"
	ComboBox $form.inbound.print.entry -ewidth 22 -strict 1 \
		-lbltext "Printer " -lblwidth 8 \
		-listwidth 22 -textvariable user_adm__rec(prtstr)
	pack $form.inbound.print.button $form.inbound.print.entry \
		-side left
	pack $form.inbound.print -side top -anchor w

	frame $form.inbound.mail
	checkbutton $form.inbound.mail.button -text "Email rcvd faxes" \
		-anchor w \
		-justify left -width 16 -var user_adm__rec(automail) \
		-onvalue "true" -offvalue "false"
	label $form.inbound.mail.label -text "Address" -padx 2 -width 8 
	entry $form.inbound.mail.entry -relief sunken \
		-width 22 -textvariable user_adm__rec(mailaddr)
	pack $form.inbound.mail.button $form.inbound.mail.label \
		$form.inbound.mail.entry -side left
	pack $form.inbound.mail -side top -anchor w

	checkbutton $form.inbound.delete -var user_adm__rec(autodel) \
	    -anchor w -justify left -onvalue "true" -offvalue "false" \
	    -text "Delete received faxes after processing (email or printing)"
	pack $form.inbound.delete -side top -anchor w

	pack $form.inbound -side top -fill x -padx 12

	#
	# Separate the form from the dialog buttons
	#
	frame $form.dlg_separator -relief groove -borderwidth 1 -height 2
	pack $form.dlg_separator -pady 16 -padx 2 -fill x 
	

	frame $form.buttons
	button $form.buttons.ok -width 6 -text "OK" \
		-command { user_adm__OK }
	button $form.buttons.cancel -width 6 -text "Cancel" \
		-command { user_adm__Cancel }
	button $form.buttons.reset -width 6 -text "Reset" \
		-command { user_adm__Reset }
	pack $form.buttons.ok $form.buttons.cancel $form.buttons.reset \
		-side left -expand 1
	pack $form.buttons -expand 1 -fill x -padx 16 -ipadx 4


	#
	# Use a frame to pad the bottom of the window
	#
	frame $form.separator1
	pack $form.separator1 -pady 8

	#
	# fill in printers list
	#
	set printers [vcl resource printers -names -count count]
	if { $count < 1 } {
		set list_count 1
	} elseif { $count > 10 } {
		set list_count 10
	} else {
		set list_count $count
	}

	$form.inbound.print.entry configure -listheight $list_count
	foreach printer $printers {
		$form.inbound.print.entry add $printer
	}

	$form.outbound.sprint.entry configure -listheight $list_count
	foreach printer $printers {
		$form.outbound.sprint.entry add $printer
	}
}


# +++PHDR+++
#
# Procedure:	user_adm__OK
#
# Description:	Callback for the "OK" button. Commits the addition or 
#               changes to the form.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:	
#
# ---PHDR---

proc user_adm__OK {} {
	global user_adm__editdone user_adm__selected user_adm__rec

	set userid [.useredit_shell.user.id.entry get]

	if { $userid == "" } {
		set result [ tk_dialog .dlg "New User" \
			"No User ID!\n\
			Select \"Cancel\" to cancel new user" \
			error 0 "OK" "Cancel" ]

		if { !$result } {
			.useredit_shell.user.id.entry configure -state normal
			focus .useredit_shell.user.id.entry
			return
		} 

		set user_adm__editdone 0
		return
	} 

	#
	# validate the password
	#
#	if { ![user_adm__ValidatePassword] } {
#		return
#	}

	#
	# If we are adding then add the user, otherwise update it
	#
	array set rec [array get user_adm__rec]
	if { ${user_adm__selected} == "" } {
		set command "add"
	} else {
		set command "update"
	}

	if { $rec(pri) == "" } {
		@user_adm $command $rec(cli) \
			-license $rec(lic) \
			-name $rec(usr) \
			-did $rec(did) \
			-type $rec(utp) \
			-mode $rec(umd) \
			-autodel $rec(autodel) \
			-automail $rec(automail) \
			-autoprint $rec(autoprint) \
			-autosprt $rec(autosprt) \
			-confirm $rec(confirm) \
			-mailaddr $rec(mailaddr) \
			-printstr $rec(prtstr) \
			-sprintstr $rec(sprtstr)
	} else {
		@user_adm $command $rec(cli) \
			-license $rec(lic) \
			-name $rec(usr) \
			-did $rec(did) \
			-type $rec(utp) \
			-mode $rec(umd) \
			-priority $rec(pri) \
			-autodel $rec(autodel) \
			-automail $rec(automail) \
			-autoprint $rec(autoprint) \
			-autosprt $rec(autosprt) \
			-confirm $rec(confirm) \
			-mailaddr $rec(mailaddr) \
			-printstr $rec(prtstr) \
			-sprintstr $rec(sprtstr)
	}

	set user_adm__editdone 1
	return
}



# +++PHDR+++
#
# Procedure:	 user_adm__Cancel
#
# Description:	"Cancel" command proc. Sets the done flag so tkwait returns.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__Cancel {} {
	global user_adm__editdone

	set user_adm__editdone 0
}


# +++PHDR+++
#
# Procedure:	user_adm__Reset
#
# Description:	"Reset" command proc. Resets the edit form to original values.
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---

proc user_adm__Reset {} {
	global user_adm__rec user_adm__saved_rec

	array set user_adm__rec [array get user_adm__saved_rec]
}


# +++PHDR+++
#
# Procedure:	user_adm__ValidatePassword
#
# Description:	Validates the entered passwords
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
#
# Returns:	1 if passwords are valid, otherwise returns 0
#
#
# Notes:
#
# ---PHDR---

proc user_adm__ValidatePassword {} {
	global user_adm__confirm user_adm__rec user_adm__saved_rec

	array set rec [array get user_adm__rec]
	array set saved_rec [array get user_adm__saved_rec]

	if { $rec(pwd) == $saved_rec(pwd) } {
		set password $rec(pwd)
	} else {
		set password [vcl crypt $rec(pwd)]
	}

	if { ${user_adm__confirm} != "" } {
		set reentered [vcl crypt ${user_adm__confirm}]
	} elseif { $rec(pwd) == $saved_rec(pwd) } {
		return 1
	} else {
		set reentered ""
	}

	set user_adm__confirm ""

	if { $password != $reentered } {
		tk_dialog .dlg "Password" \
			"Password and Re-Enter password don\'t match!" \
			error 0 "OK"

		focus .useredit_shell.pw.confirm.entry
		return 0
	} else {
		return 1
	}
}


# +++PHDR+++
#
# Procedure:	user_adm__Popup
#
# Description:
#
#
# Argument		Description
# --------------------	----------------------------------------------------
#
#
# Returns:
#
#
# Notes:
#
# ---PHDR---

proc user_adm__Popup { parent user_adm_shell } {
	global user_adm__shell user_adm__done

	#
	# Get a user admin object
	#
	catch { vcl destroy @user_adm }
	vcl user @user_adm

	#
	# Build and display the User database form
	#
	user_adm__BuildMainForm $user_adm_shell

	user_adm__FillList
	vclutils__SetSelected 0 ${user_adm__shell}.lists.id.list \
		${user_adm__shell}.lists.name.list \
		${user_adm__shell}.lists.type.list \
		${user_adm__shell}.lists.lic.list

	vclutils__CenterDialog $user_adm_shell $parent
	vclutils__LockSize $user_adm_shell

	#
	# Make the dialog modal
	#
	update
	grab ${user_adm__shell}

	#
	# Wait for the dialog to be done
	#
	tkwait variable user_adm__done
	grab release ${user_adm__shell}

	#
	# Destroy everything we created
	#
	catch { vcl destroy @user_adm }
	if { ${user_adm__shell} != "." } {
		catch { destroy ${user_adm__shell} }
	} else {
		exit
	}
}


# +++PHDR+++
#
# Procedure:	main entry point
#
# Description:	This is the entry point to popup the User database editor
#
#
# Argument		Description
# --------------------	----------------------------------------------------
# n/a
#
# Returns:	nothing
#
#
# Notes:
#
# ---PHDR---


