# ------------------------------------------------------------------------
#
#	Description:
#
#	script to convert inbound faxes to standard tiff format and route
#	them to the appropriate inbox
#
#	usage:	<rnp> path dest inbox
#
# ------------------------------------------------------------------------

global argv argc env

# ------------------------------------------------------------------------
# Get all arguments
#
set FILE	[ lindex $argv 0 ]
set DEST	[ lindex $argv 1 ]
set INBOX	[ lindex $argv 2 ]
set TSI		"VSI-FAX"

set VSIFAX	$env(VSIFAX)

set SPAM_USER	"vsispam"
set SPAM_TSI	"spam"

if { [string compare $INBOX ""] == 0 } {
	set INBOX vsifax
}

cd [ file dirname "$FILE" ]

# ------------------------------------------------------------------------
# Adjust INBOX & TSI if needed
#
set info ""
catch { set info [ exec "$VSIFAX/bin/vtifftool" info -F tcl "$FILE" ] }
if { [string compare "$info" ""] != 0 } {
	eval $info

	# ----------------------------------------------------------------
	# check if DID extension present in fax file
	# and if so change INBOX to user owning that DID ext
	#
	if { [string compare "$did" ""] != 0 } {
		set name ""
		catch { set name [ exec "$VSIFAX/bin/vfxadmin" user -E "$did" ] }
		if { [string compare "$name" ""] == 0 } {
			set name "$did"
		}

		set status [ catch { exec "$VSIFAX/bin/vfxadmin" user -Tq "$name" } ]
		if { $status == 0 } {
			set INBOX "$name"
		}
	}

	# ----------------------------------------------------------------
	# If the TSI is empty, it is probably a spam fax.
	# If a spam user is present, route to him.
	#
	if { [string compare "$tsi" ""] == 0 } {
		set status [ catch { exec "$VSIFAX/bin/vfxadmin" user -Tq "$SPAM_NAME" } ]
		if { $status == 0 } {
			set INBOX "$SPAM_NAME"
			set TSI   "$SPAM_TSI"
		}
	} else {
		set TSI "$tsi"
	}
}

# ------------------------------------------------------------------------
# Add the thumbnails to the file (ignore any error from it)
#
catch { exec "$VSIFAX/bin/vtifftool" thumb -o "$FILE" "$FILE" }

# ------------------------------------------------------------------------
# Run the receive program
#
catch { exec "$VSIFAX/lbin/vrecv" "$FILE" "$INBOX" }

# ------------------------------------------------------------------------
# Run the site RNP if it exists
#
catch { exec "$VSIFAX/lbin/vnotify" -n -r site \
	"$FILE" "$DEST" "$INBOX" "received" }

# ------------------------------------------------------------------------
# If the file still exists,
# check if a specific RNP exists for this destination
# and if so, run it
#
if { [ file exists "$FILE" ] } {
	set RNP ""
	catch { set RNP [ exec "$VSIFAX/bin/vfxadmin" device -l \
		-f rnp -F pipe "$DEST" ] }
	if { [string compare "$RNP" "system"] == 0 || \
	     [string compare "$RNP" "site"]   == 0 } {
		set RNP ""
	}

	if { [string compare "$RNP" ""] != 0 } {
		catch { exec "$VSIFAX/lbin/vnotify" -r "$RNP" \
			"$FILE" "$DEST" "$INBOX" "received" }
	}
}

# ------------------------------------------------------------------------
# Route the file to the appropriate inbox if it still exists
#
catch { exec "$VSIFAX/lbin/vroute" -r "$FILE" "$TSI" "$INBOX" }

exit 0
