# ------------------------------------------------------------------------
#
#	Description:
#
#	This is the default system LNP for all jobs
#
#	usage: <lnp> reqid clientid mailaddr time notify grpid
#			numpgs faxnum lcr
#
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
#  procedure for checking a reg fax job
#
proc lcr_check_reg { } {
	global LCR ALB REQID VSIFAX

	# ----------------------------------------------------------------
	# check if this job should be routed
	#
	if { [string compare "$LCR" "TRUE"] == 0 || \
	     [string compare "$ALB" "TRUE"] == 0 } {
		set route ""

		if { [string compare "$LCR" "TRUE"] == 0 && [string compare "$ALB" "TRUE"] == 0 } {
			catch { set route [ exec "$VSIFAX/lbin/vlcrchk" -a -l $REQID ] }
		}
		
		if { [string compare "$LCR" "TRUE"] == 0 && [string compare "$ALB" "TRUE"] != 0 } {
			catch { set route [ exec "$VSIFAX/lbin/vlcrchk" -l $REQID ] }
		}
		
		if { [string compare "$LCR" "TRUE"] != 0 && [string compare "$ALB" "TRUE"] == 0 } {
			catch { set route [ exec "$VSIFAX/lbin/vlcrchk" -a $REQID ] }
		}

		if { [string compare "$route" ""] != 0 } {

			# ------------------------------------------------
			# route this job
			#
			catch { exec "$VSIFAX/lbin/vlcrfwd" [lindex $route 0] [lindex $route 1] $REQID }
			return
		}
	}

	# ----------------------------------------------------------------
	# check if this job should be moved to another dest
	#
	set dest ""
	catch { set dest [ exec "$VSIFAX/lbin/vdevchk" $REQID ] }
	if { [string compare "$dest" ""] != 0 } {

		# --------------------------------------------------------
		# move this job
		#
		catch { exec "$VSIFAX/lbin/vlcrfwd" -d "$dest" $REQID }
		return
	}
}

# ------------------------------------------------------------------------
#  procedure for checking a grp fax job
#
proc lcr_check_grp { } {
	global LCR ALB GRPID NUM VSIFAX

	# ----------------------------------------------------------------
	# get coverpage for this group
	#
	catch { set faxreq [ exec "$VSIFAX/lbin/vfaxreq" -F tcl g-$GRPID ] }
	eval $faxreq

	# ----------------------------------------------------------------
	# loop through all members of this group
	#
	for { set mem 1 } { $mem <= $NUM } { incr mem } {

		# --------------------------------------------------------
		# check if this member should be routed
		#
		if { [string compare "$LCR" "TRUE"] == 0 || \
		     [string compare "$ALB" "TRUE"] == 0 } {
			set route ""

			if { [string compare "$LCR" "TRUE"] == 0 && [string compare "$ALB" "TRUE"] == 0 } {
				catch { set route [ exec "$VSIFAX/lbin/vlcrchk" -a -l g-$GRPID-$mem ] }
			}
			
			if { [string compare "$LCR" "TRUE"] == 0 && [string compare "$ALB" "TRUE"] != 0 } {
				catch { set route [ exec "$VSIFAX/lbin/vlcrchk" -l g-$GRPID-$mem ] }
			}
			
			if { [string compare "$LCR" "TRUE"] != 0 && [string compare "$ALB" "TRUE"] == 0 } {
				catch { set route [ exec "$VSIFAX/lbin/vlcrchk" -a g-$GRPID-$mem ] }
			}

			if { [string compare "$route" ""] != 0 } {

				# ----------------------------------------
				# image the cover for this member if needed
				#
				if { [string compare "$cvr" ""] != 0 } {
					catch { exec "$VSIFAX/lbin/vcover" \
						"$cvr" g-$GRPID-$mem }
				}

				# ----------------------------------------
				# now route it
				#
				catch { exec "$VSIFAX/lbin/vlcrfwd" [lindex $route 0] [lindex $route 1] \
					g-$GRPID-$mem }
				continue
			}
		}

		# --------------------------------------------------------
		# check if this member should be moved to another dest
		#
		set dest ""
		catch { set dest [ exec "$VSIFAX/lbin/vdevchk" g-$GRPID-$mem ] }
		if { [string compare "$dest" ""] != 0 } {

			# ------------------------------------------------
			# move this member
			#
			catch { exec "$VSIFAX/lbin/vlcrfwd" -d "$dest" \
				g-$GRPID-$mem }
			continue
		}
	}
}

global argv argc env

# ------------------------------------------------------------------------
#  get all arguments
#
set REQID	[ lindex $argv 0  ]
set CLIENTID	[ lindex $argv 1  ]
set MAILADDR	[ lindex $argv 2  ]
set SENDTIME	[ lindex $argv 3  ]
set NOTIFY	[ lindex $argv 4  ]
set GRPID	[ lindex $argv 5  ]
set NUM		[ lindex $argv 6  ]
set FAXNUM	[ lindex $argv 7  ]
set LCR		[ lindex $argv 8  ]
set ALB		[ lindex $argv 9  ]
set USER_LNP	[ lindex $argv 10 ]

set VSIFAX	$env(VSIFAX)

# ------------------------------------------------------------------------
# if a reg job, check if it was routed & send a confirmation if it was
#
if { $GRPID == 0 } {
	catch { exec "$VSIFAX/lbin/vlcrstat" $REQID }
}

# ------------------------------------------------------------------------
# run the site LNP if it exists
#
set status [ catch \
	{ exec "$VSIFAX/lbin/vnotify" -n -l site \
		"$REQID" \
		"$CLIENTID" \
		"$MAILADDR" \
		"$SENDTIME" \
		"$NOTIFY" \
		"$GRPID" \
		"$NUM" \
		"$FAXNUM" \
		"$LCR" \
	} ]
if { $status != 0 } {
	exit 1
}

# ------------------------------------------------------------------------
# run the <user> LNP if it exists
#
if { [string compare "$USER_LNP" ""] != 0 } {

	set status [ catch \
		{ exec "$VSIFAX/lbin/vnotify" -l "$USER_LNP" \
			"$REQID" \
			"$CLIENTID" \
			"$MAILADDR" \
			"$SENDTIME" \
			"$NOTIFY" \
			"$GRPID" \
			"$NUM" \
			"$FAXNUM" \
			"$LCR" \
		} ]
	if { $status != 0 } {
		exit 1
	}
}

# ------------------------------------------------------------------------
# check if this fax should be routed (LCR)
#
if { $GRPID == 0 } {
	lcr_check_reg
} else {
	lcr_check_grp
}

exit 0
