// +++FHDR+++
//
//
//   Class Name : VxmldTransport
//   Super Class: DocumentTransport
//
//   Description: This class implements a DocumentTransport for transporting
//                XMLF documents to the VSI-FAX xmld daemon.
//
//
//   Notes      : none
//
//
//   Method - Description
//   ------------------------------------------------------------------------
//
//
// ---FHDR---

#ifndef _VXMLDTRANSPORT_H_
#define _VXMLDTRANSPORT_H_

#include "DocumentTransport.h"
#include "OutputString.h"

class VxmldTransport : public DocumentTransport {

  private:
	static int _sockets_initialized;

  protected:
	OutputString _err_msg;

  public:
	VxmldTransport();
	~VxmldTransport();

	char * getLastError ();

	char * send (char * url, char * xml_data);
	char * send (char * url, istream * xml_stream);

	static int initializeSockets();
	static void deinitializeSockets();
};

#endif // _VXMLTRANSPORT_H_

