// +++FHDR+++
//
//
//   Class Name : TmpStream
//   Super Class: fstream
//
//   Description: This class creates a temporary file. The physical file
//		  is deleted when the object is destructed.
//
//
//   Notes      : none
//
//
//   Method - Description
//   ------------------------------------------------------------------------
//
//
// ---FHDR---


#if _WIN32
#  include <windows.h>
#  include <stdio.h>
#else
#  include <stdio.h>
#  include <unistd.h>
#endif

#include <stdlib.h>
#include <string.h>
#include "TmpStream.h"



// +++PHDR+++
//
//  Method     : TmpStream::TmpStream() - Default constructor
//
//  Visibility : public
//
//  Description: TmpStream class default constructor
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  none
//
//  Returns:   n/a
//
//
//  Notes:     none
//
// ---PHDR---

TmpStream::TmpStream() : fstream()
{
	char namebuf[256];
	const char * tmpdir;

	_filename = NULL;

	/*
	 * first thing we need to do is get the directory to put the file in
	 */
	tmpdir = getenv("TMP");
	if (tmpdir == NULL)
		tmpdir = getenv("TEMP");
	if (tmpdir == NULL)
		tmpdir = getenv("TMPDIR");

	if (tmpdir == NULL) {
#if _WIN32
	char tmpdir_buf[256];

		tmpdir = getenv("SystemRoot");
		if (tmpdir != NULL) {
			sprintf(tmpdir_buf, "%s\\TEMP", tmpdir);
			tmpdir = tmpdir_buf;
		} else {
			tmpdir = "\\temp";
		}
#else
		tmpdir = "/tmp";
#endif
	}


	/*
	 * Now create a unique filename with the following for:
	 *
	 *	{tmpdir}/tmp{pid}.xxx (x is a character from a-z)
	 */
	int ch1, ch2, ch3;
	int pid;
#if _WIN32
	pid = GetCurrentProcessId();
#else
	pid = getpid();
#endif
	for (ch1 = 'a'; _filename == NULL && ch1 <= 'z'; ch1++) {
	        for (ch2 = 'a'; _filename == NULL && ch2 <= 'z'; ch2++) {
	        	for (ch3 = 'a'; ch3 <= 'z'; ch3++) {

				sprintf(namebuf, "%s/tmp%d.%c%c%c", 
					tmpdir, pid, ch1, ch2, ch3);
#if _WIN32
				open(namebuf, ios::in | ios::out | ios::binary | ios_base::trunc);
				if (!is_open() || bad())
#else
#	if _XIOSBASE_ || _CPP_BITS_IOSBASE_H || _IOS_BASE_H
				open(namebuf, ios::in | ios::out | ios_base::trunc);
#	else
				open(namebuf, ios::in | ios::out);
#	endif
				if (bad())
#endif
				{
					close();
					continue;
				}

				_filename = new char[strlen(namebuf) + 1];
				strcpy(_filename, namebuf);
				break;
			}
		}
        }
}


// +++PHDR+++
//
//  Method     : TmpStream::~TmpStream() - Default destructor
//
//  Visibility : public
//
//  Description: TmpStream class default destructor
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  n/a
//
//  Returns:   n/a
//
//
//  Notes:     none
//
// ---PHDR---

TmpStream::~TmpStream()
{
	if (_filename == NULL)
		return;

	sync();
	close();

#if _WIN32
        DeleteFile(_filename);
#else
        unlink(_filename);
#endif

	delete _filename;
	_filename = NULL;
}


// +++PHDR+++
//
//  Method     : TmpStream::getFilename
//
//  Visibility : public
//
//  Description: Returns the filename of the temporary file
//		 attached to the stream.
//
//  Parameter       Type                    Description
//  --------------- ----------------------- ----------------------------------
//  none
//
//
//  Returns:   	const char * pointing to the name of the temporary file.
//
//
//  Notes:     none
//
// ---PHDR---

const char *
TmpStream::getFilename ()
{
	return (_filename);
}

