
import com.vsi.xmlf.*;
import java.io.FileInputStream;
import java.io.File;
import java.util.Vector;


class xmlftest {

	public static void main (String args[]) {

		String url_spec = "localhost";
		String username = "vsifax";
		Vector files = new Vector();
		Vector recipients = new Vector();
		String type = "submit";
		int count = 1;
		boolean include_cover = false;
		boolean check_failure = false;

		
		/*
		 * Parse the command line
		 */
		CmdLine cmdline = new CmdLine("a:n:h:u:c:t:Cf?");
		for (int c = cmdline.getOpt(args);
			c != CmdLine.EOF; 
			c = cmdline.getOpt(args)) {

			switch (c) {

			  case 'C':
				include_cover = true;
				break;

			  case 'a':
				files.addElement(cmdline.getOptArg());
				break;

			  case 'n':
				recipients.addElement(cmdline.getOptArg());
				break;

			  case 'f':
				check_failure = true;
				break;

			  case 'h':
				url_spec = cmdline.getOptArg();
				break;

			  case 'u':
				username = cmdline.getOptArg();
				break;

			  case 'c':
				count = Integer.parseInt(cmdline.getOptArg());
				break;

			  case 't':
				type = cmdline.getOptArg();
				break;

			  case '?':
				usage();
				System.exit(0);

			  case CmdLine.ERROR:
				System.err.println(cmdline.getErrorMsg());
				System.exit(1);
				break;
			}
		}

	
		/*
		 * Validate the request type
		 */
		if (type.equalsIgnoreCase("submit")) {
			type = "submit";
		} else if (type.equalsIgnoreCase("status")) {
			type = "status";
		} else if (type.equalsIgnoreCase("cancel")) {
			type = "cancel";
		} else {
			System.err.println("Error: invalid request type (" +
				type + ")");
			System.exit(1);
		}


		/*
		 * Open the transport manager
		 */
		TransportManager mgr	 = new TransportManager();

		/*
		 * Bind the vxmld (defdault) transport
		 */
		VxmldTransport transport = new VxmldTransport();
		mgr.bindTransport("vxmld", transport);
		mgr.setDefaultTransport("vxmld");
		

		/*
		 * Bind the XMLF document decoders
		 */
		DocumentDecoder decoder;

		decoder = new SubmitRequestDecoder();
		decoder.bind(mgr);

		decoder = new StatusRequestDecoder();
		decoder.bind(mgr);

		decoder = new CancelRequestDecoder();
		decoder.bind(mgr);

		decoder = new SubmitResponseDecoder();
		decoder.bind(mgr);

		decoder = new StatusResponseDecoder();
		decoder.bind(mgr);

		decoder = new CancelResponseDecoder();
		decoder.bind(mgr);


		/*
		 * create the account object. We'll use it several times
		 */
		Account account = new Account(username, null, null);

		Request req = null;
		if (!check_failure || type.equals("submit")) {
			req = createSubmitRequest(check_failure, 
				include_cover, files, recipients);
		} else if (type.equals("cancel")) {
			req = new CancelRequest();
			req.setServiceReference("9999999");
		} else {
			req = new StatusRequest();
			req.setServiceReference("9999999");
		}
		
		Request cancel_req = null;
		if (!check_failure || type.equals("cancel")) {
			cancel_req = new CancelRequest();
			cancel_req.setAccount(account);
		}

		req.setAccount(account);

		System.out.println("\nServer: " + url_spec);
		System.out.println("request type: " + type);
		if (!check_failure) {
			    System.out.println("Check type: success");
		} else {
			    System.out.println("Check type: failure");
		}


		/*
		 * Setup the status request if thats what we are doing
		 */
		if (!check_failure && type.equals("status")) {
			System.out.print("Sending submit request...");
			Response rsp = mgr.send(url_spec, req);
			System.out.println("done");
			if (rsp == null) {
				System.out.println("");
				System.out.println("ERROR: " +
					mgr.getLastError());
				System.exit(1);
			}

			req = new StatusRequest();
			req.setAccount(account);
			req.setServiceReference(rsp.getServiceReference());
		}

		System.out.println("");

		/*
		 * Perform the specified test the specified count of times
		 */
		for (int i = 0; i < count; i++) {

			System.out.println("Test " + (1 + i));
			System.out.println("--------------------------------");

			if (!check_failure && type.equals("cancel")) {
			    System.out.print("Sending submit request...");
			} else {
			    System.out.print("Sending " + type + " request...");
			}

			Response rsp = mgr.send(url_spec, req);
			System.out.println("done");
			if (rsp == null) {
				System.out.println("");
				System.out.println("ERROR: " +
					mgr.getLastError());
				System.exit(1);
			}

			boolean passed = rsp.getRequestResults().isNormal();

			if (check_failure) {

				RequestResults rr = rsp.getRequestResults();
				if (passed) {
					System.out.println("FAIL (" +
						rr.getMessage() + ")");
				} else {
					System.out.println("PASS (" +
						rr.getMessage() + ")");
				}

				System.out.println("");
				continue;
			} 

			if (passed && type.equals("cancel")) {

			    	System.out.print("Sending cancel request...");
				cancel_req.setServiceReference(
					rsp.getServiceReference());
				rsp = mgr.send(url_spec, cancel_req);
				System.out.println("done");
				if (rsp == null) {
					System.out.println("");
					System.out.println("ERROR: " +
						mgr.getLastError());
					System.exit(1);
				}

				passed = rsp.getRequestResults().isNormal();
			}

			if (passed) {
				System.out.println("PASS");
			} else {
				System.out.println("FAIL (" +
				    rsp.getRequestResults().getMessage() + ")");
			}

			System.out.println("");
		}
	}


	static Request createSubmitRequest (boolean check_failure,
		boolean include_cover, Vector files, Vector recipients) {

		SubmitRequest req = new SubmitRequest();

		if (check_failure) {
			return (req);
		}


		req.setIncludeCoversheet(include_cover);

		if (files != null && files.size() > 0) {

			int num_files = files.size();
			for (int i = 0; i < num_files; i++) {
				FileBody body = 
				    new FileBody((String)files.elementAt(i));
				req.addContent(body);
			}

		} else {
			req.addContent(new InlineBody("This is a test fax"));
		}

		FaxNumber fax = new FaxNumber("555-1212");
		VoiceNumber voice = new VoiceNumber("555-1212");

		Sender sender = new Sender("John Doe", "Company", fax, voice);
		req.setSender(sender);

		if (recipients != null && recipients.size() > 0) {
			
			int num_recipients = recipients.size();
			for (int i = 0; i < num_recipients; i++) {
				fax = new FaxNumber(
					(String)recipients.elementAt(i));
				req.addRecipient(
					new Recipient("recipient " + (i + 1),
						"Company", fax, null));
			}

		} else {
			req.addRecipient(new Recipient(
				"Mr. Fax", "Company", fax, voice));
		}
		
	
		return (req);	
	}


	static void usage () {

		System.out.println("Usage: xmlftest [options]");
		System.out.println("where options are:");
		System.out.println("  -h hostname    server hostname");
		System.out.println("  -u username    username");
		System.out.println(
		    "  -t test-type   test to run (submit, status, or cancel)");
		System.out.println(
		    "  -c count       number of times to run the test");
		System.out.println(
		    "  -a filename    attach filename to submit request");
		System.out.println(
		    "  -n number      add number as a recipient");
		System.out.println("  -C             include cover page");
		System.out.println("  -f             test failure handling");
		System.out.println(
		    "  -?             display this help message");
	}
}
