package com.vsi.xmlf.beans;

import com.vsi.xmlf.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;
import javax.swing.plaf.ComponentUI;

import java.awt.*;
import java.awt.event.*;
import java.awt.event.WindowAdapter;
import java.util.*;
import java.io.*;

import java.beans.*;

/**
 *
 */
public class QuickSubmitForm extends JPanel
	implements java.io.Serializable, FocusListener {

	protected transient JDialog _dialog = null;

	protected transient FaxOptions _options = null;
	protected transient FaxOptionsForm _options_form = null;

	protected transient JFileChooser _file_dialog = null;
	protected transient Hashtable  _commands    = null;

	protected PersonForm _to_form = null;
	protected transient TitledBorder _to_border = null;

	protected transient JRadioButton _yes_btn = null;
	protected transient JRadioButton _no_btn  = null;
	protected boolean _include_cover_value = false;

	protected transient JTextField _subject = null;
	protected String _subject_value = "";

	protected transient JTextArea  _body = null;
	protected transient TitledBorder _body_border = null;
	protected String _body_value = "";

	protected transient JTextField _attachments = null;
	protected transient JButton _attachments_btn = null;
	protected String _attachments_value = "";

	protected transient JButton _options_btn = null;
	
	protected transient JToolBar _toolbar = null;
	protected transient JPanel _text_wrapper = null;

	protected boolean _body_visible = true;

	protected Font _text_font = new Font("Dialog", Font.PLAIN, 12);

	protected Vector _rsp_listeners = new Vector();

	protected transient TransportManager _mgr =
		TransportManager.getDefault();


	protected static Class _set_classes[] = new Class[5];
	static {
	    try {
		_set_classes[0] = Class.forName("javax.swing.JLabel");
		_set_classes[1] = Class.forName("javax.swing.JButton");
		_set_classes[2] = Class.forName("javax.swing.JRadioButton");
		_set_classes[3] = Class.forName("javax.swing.JPanel");
		_set_classes[4] = Class.forName("javax.swing.JToolBar");
	    } catch (Exception e) {
	    }
	}




	/**
	 * Actions defined by the QuickSubmitForm class
	 */
	private transient Action[] defaultActions = {
		new ClearAction(),
		new AttachAction(),
		new SubmitAction(),
		new FaxOptionsAction()
	};


	public QuickSubmitForm () {

		_options = new FaxOptions(".xmlfrc");
		createUi();
	}


	protected void createUi () {

		setLayout(new BorderLayout());
		setAlignmentX(LEFT_ALIGNMENT);
		setAlignmentY(TOP_ALIGNMENT);

		_to_border = new TitledBorder(new EtchedBorder(), "To");
		_to_form = new PersonForm();
		_to_form.setBorder(_to_border);
		_to_form.setTextFont(_text_font);

		LabeledPairLayout layout = new LabeledPairLayout();
		JPanel group = new JPanel(layout);
		Insets insets = _to_form.getInsets();
		insets.top = insets.bottom;
		group.setBorder(new EmptyBorder(insets));

		JLabel l = new JLabel("Subject: ", JLabel.RIGHT);
		_subject = new JTextField(_subject_value, 25);
		_subject.addFocusListener(this);
		l.setLabelFor(_subject);
		l.setDisplayedMnemonic('S');
		group.add(l, "label");
		group.add(_subject, "field");

		l = new JLabel("  Attachments: ", JLabel.RIGHT);
		_attachments = new JTextField(_attachments_value, 22);
		_attachments.addFocusListener(this);
		l.setLabelFor(_attachments);
		l.setDisplayedMnemonic('A');
	
		group.add(l, "label");


		/*
		 * Create the fax body input area
		 */
		_text_wrapper = new JPanel(new BorderLayout());
		_text_wrapper.setAlignmentX(LEFT_ALIGNMENT);
		_body_border = new TitledBorder(new EtchedBorder(), "Fax Body");
	 	_text_wrapper.setBorder(_body_border);

		_body = new JTextArea(_body_value);
		_body.setFont(_text_font);
		_body.addFocusListener(this);
		TextScroller scroller = new TextScroller();
		scroller.getViewport().add(_body);
		_body.setEditable(true);


		/*
		 * Install the command table
		 */
		_commands = new Hashtable();
		Action[] actions = getActions();
		for (int i = 0; i < actions.length; i++) {
			Action action = actions[i];
			_commands.put(action.getValue(Action.NAME), action);
		}	


		/*
		 * We add the attachments button here because we needed
		 * to set up the actions first.
		 */
		_attachments_btn = addButton(null, "attach",
				"attach", "select a file to attach");
		JPanel attachments = new JPanel(new BorderLayout(0, 0));
		attachments.add(_attachments, BorderLayout.CENTER);
		attachments.add(_attachments_btn, BorderLayout.EAST);
		group.add(attachments, "field");


		/*
		 *
		 */
		l = new JLabel("Include Cover: ", JLabel.RIGHT);
		_yes_btn = new JRadioButton("yes");
		l.setLabelFor(_yes_btn);
		l.setDisplayedMnemonic('I');
		_yes_btn.setSelected(true);
		_no_btn = new JRadioButton("no");
		_no_btn.setSelected(false);
		ButtonGroup btn_group = new ButtonGroup();
		btn_group.add(_yes_btn);
		btn_group.add(_no_btn);
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		p.add(_yes_btn);
		p.add(_no_btn);
		group.add(l, "label");
		group.add(p, "field");

		_toolbar = new JToolBar();
		_toolbar.setFloatable(false);
		addButton(_toolbar, "clear", "clear", "clear message body");
		addButton(_toolbar, "cut",   "cut-to-clipboard", "cut");
		addButton(_toolbar, "copy",  "copy-to-clipboard", "copy");
		addButton(_toolbar, "paste", "paste-from-clipboard", "paste");
		_toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);

		_text_wrapper.add(_toolbar, BorderLayout.NORTH);
		_text_wrapper.add(scroller, BorderLayout.CENTER);

		_options_btn = addButton(null, "Fax Options...",
			"fax-options", "modify sender info, resolution," +
			" priority and account settings");
		
		GridBagLayout gb = new GridBagLayout();
		JPanel top_group = new JPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		top_group.setLayout(gb);
		gbc.weightx = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.gridy = 0;
		top_group.add(_to_form, gbc);
		gbc.gridy = 1;
		top_group.add(group, gbc);
		gbc.gridy = 2;
		gbc.insets = new Insets(0, 2, 8, 0);
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		top_group.add(_options_btn, gbc);
		add(top_group, BorderLayout.NORTH);
		add(_text_wrapper, BorderLayout.CENTER);

		setFont(getFont());
		setBackground(getBackground());
		setForeground(getForeground());
	}


	private void writeObject(java.io.ObjectOutputStream out)
		throws IOException {

		JComponent parent = this; 
	 	for (Container p = getParent(); p != null; p = p.getParent()) {
		        if (p instanceof JComponent) {
		            parent = (JComponent)p;
		        }
		}

		ComponentUI ui = UIManager.getUI(parent);
		ui.uninstallUI(parent);

		try {
			out.defaultWriteObject();
		} catch (IOException ioe) {
			throw new IOException(ioe.getMessage());	
		} finally {
			ui.installUI(parent);
		}
	}



	public void addPropertyChangeListener(PropertyChangeListener listener) {
		super.addPropertyChangeListener(listener);
		_to_form.addPropertyChangeListener(listener);
	}


	public void removePropertyChangeListener(
		PropertyChangeListener listener) {

		super.removePropertyChangeListener(listener);
		_to_form.removePropertyChangeListener(listener);
	}


	public void setBackground (Color c) {
		super.setBackground(c);

		if (_to_border == null) {
			return;
		}

		GuiUtils.setChildrenBackground(this, _set_classes, c);
	}


	public void setForeground (Color c) {
		super.setForeground(c);

		if (_to_border == null) {
			return;
		}

		GuiUtils.setChildrenForeground(this, _set_classes, c);
		_to_border.setTitleColor(c);
		_body_border.setTitleColor(c);
	}


	public Font getTextFont () {
		return (_text_font);
	}



	public void setTextFont (Font f) {

		_text_font = f;

		if (_to_form == null) {
			return;
		}

		_to_form.setTextFont(f);
		_subject.setFont(f);
		_attachments.setFont(f);
		_body.setFont(f);
	}


	public void setFont (Font f) {
		super.setFont(f);

		if (_to_border == null) {
			return;
		}

		GuiUtils.setChildrenFont(this, _set_classes, f);
		_to_border.setTitleFont(f);
		_body_border.setTitleFont(f);
	}


	public synchronized void setFaxBodyVisible (boolean showit) {

		if (_body_visible == showit) {
			return;
		}

		_body_visible = showit;
		if (_text_wrapper != null) {
			_text_wrapper.setVisible(showit);

			if (showit) {
			    _text_wrapper.update(_text_wrapper.getGraphics());
			}
		}
	}


	public synchronized boolean isFaxBodyVisible () {
		return (_body_visible);
	}


	public String getToName () {
		return (_to_form.getPersonalName());
	}


	public void setToName (String value) {
		_to_form.setPersonalName(value);
	}


	public String getToCompany () {
		return (_to_form.getCompanyName());
	}


	public void setToCompany (String value) {
		_to_form.setCompanyName(value);
	}


	public String getToFaxNumber () {
		return (_to_form.getFaxNumber ());
	}


	public void setToFaxNumber (String value) {
		_to_form.setFaxNumber(value);
	}


	public String getToVoiceNumber () {
		return (_to_form.getVoiceNumber());
	}


	public void setToVoiceNumber (String value) {
		_to_form.setVoiceNumber(value);
	}


	public synchronized String getSubject () {
		_subject_value = _subject.getText();
		return (_subject_value);
	}


	public synchronized void setSubject (String subject) {
		firePropertyChange("Subject", _subject_value, subject);
		_subject_value = subject;
		_subject.setText(subject);
	}


	public synchronized String getAttachments () {
		_attachments_value = _attachments.getText();
		return (_attachments_value);
	}


	public synchronized void setAttachments (String attachments) {
		firePropertyChange(
			"Attachments", _attachments_value, attachments);
		_attachments_value = attachments;
		_attachments.setText(attachments);
	}


	public synchronized void addAttachment (String filename) {
		if (filename == null) {
			return;
		}

		filename = filename.trim();
		if (filename.length() > 0) {
			String tmp = _attachments.getText();
			if (tmp != null && tmp.length() > 0) {
				_attachments.setText(tmp + "; " + filename);
			} else {
				_attachments.setText(filename);
			}
		}
	}


	public synchronized boolean getIncludeCoversheet () {
		_include_cover_value = _yes_btn.isSelected();
		return (_include_cover_value);
	}


	public synchronized void setIncludeCoversheet (boolean flag) {
		if (flag) {
			_yes_btn.setSelected(true);
		} else {
			_no_btn.setSelected(true);
		}
	}
			


	public synchronized void setBody (String text) {

		firePropertyChange("Body", _body_value, text);
		_body_value = text;

		Document doc = new PlainDocument();

		if (text == null) {
			getTextArea().setDocument(doc);
			return;
		}
		
		try {
			doc.insertString(0, text, null);
			getTextArea().setDocument(doc);
		} catch (Exception e) {
		}
	}

	public synchronized String getBody () {
		Document doc = getTextArea().getDocument();

		try {
			_body_value = doc.getText(0, doc.getLength());
			return (_body_value);
		} catch (Exception ignore) {
			return (null);
		}
	}


	/**
	 * Add a response event listener.
	 *
	 * @param  l  The ResponseListener to add.
	 */
	public synchronized void addResponseListener (ResponseListener l) {
		_mgr.addResponseListener(l);
	}


	/**
         * Remove a response event listener.
         *
         * @param  l  The ResponseListener to remove.
         */
	public synchronized void removeResponseListener (ResponseListener l) {
		_mgr.removeResponseListener(l);
	}

	
	public void submit () {
		SubmitRequest request = getSubmitRequest();
		_mgr.backgroundSend(_options.getServerUrl(), request);
	}


	public synchronized SubmitRequest getSubmitRequest () {

		/*
		 * Get all the data from the QuickSubmitForm bean and put it
		 * in the SubmitRequest object
		 */
		SubmitRequest request = new SubmitRequest();

		request.addRecipient(new Recipient(
			getToName(), getToCompany(),
			new FaxNumber(getToFaxNumber()),
			new VoiceNumber(getToVoiceNumber())));

		request.setAccount(_options.getAccount());
		request.setSender(_options.getSender());
		request.setIncludeCoversheet(getIncludeCoversheet());
		request.setSubject(getSubject());
		request.setPriority(_options.getPriority());
		request.setResolution(_options.getResolution());
		request.setNotifyWhen(_options.getNotifyWhen());
		request.setNotifyWho(_options.getNotifyWho());

		String body = getBody();
		if (body != null && body.length() > 0) {
			request.addContent(new InlineBody(body));
		}

		String s = getAttachments();
		if (s != null && s.length() > 0) {
			String attachments[] =
			    com.vsi.xmlf.Utilities.splitDelimitedString(s, ";");
			for (int i = 0; i < attachments.length; i++) {
				if (attachments[i] != null) {
					String fname = attachments[i].trim();
					FileBody fb = new FileBody(fname);
					request.addContent(fb);
				}
			}
		}

		return (request);
	}


	class TextScroller extends JScrollPane {

	    public Dimension getPreferredSize () {
		return new Dimension(100, 200);
	    }
	    public float getAlignmentX () {
		return LEFT_ALIGNMENT;
	    }
	}


	protected JButton addButton(Container parent, String name, 
		String action_name, String tooltip) {

		java.net.URL url = getClass().getResource(
			"images/" + name + ".gif");
		if (url == null) {
			url = getClass().getResource(
				"com/vsi/xmlf/beans/images/" + name + ".gif");
		}

		JButton b;
		if (url != null) {
			b = new JButton(new ImageIcon(url));
		} else {
			b = new JButton(name);
		}

		if (parent != null) {
			parent.add(b);
		}

		b.setToolTipText(tooltip);
		b.setMargin(new Insets(0,0,0,0));

		Action a = getAction(action_name);
		if (a != null) {
			b.setActionCommand(action_name);
			b.addActionListener(a);
		} else {
			b.setEnabled(false);
		}

		return (b);
	}


	class ClearAction extends AbstractAction {

	    ClearAction() {
	        super("clear");
	    }

	    ClearAction(String action_name) {
	        super(action_name);
	    }

	    public void actionPerformed(ActionEvent e) {
	        getTextArea().setDocument(new PlainDocument());
	        revalidate();
	    }
	}


	class SubmitAction extends AbstractAction {

		SubmitAction() {
			super("submit");
		}

		public void actionPerformed(ActionEvent e) {
			submit();
		}
	}


	class AttachAction extends AbstractAction {

	    AttachAction() {
	        super("attach");
	    }

	    public void actionPerformed(ActionEvent e) {
	        if (_file_dialog == null) {
	        	_file_dialog = new JFileChooser();
			GuiUtils.centerDialog(
				_file_dialog,
				(Component)e.getSource());
	        }

		int rc = _file_dialog.showOpenDialog((Component)e.getSource());
		if (rc != JFileChooser.APPROVE_OPTION) {
	            return;
	        }

		File f = _file_dialog.getSelectedFile();
	        if (f.exists()) {
				String path = f.getAbsolutePath();
				String tmp = _attachments.getText();
				if (tmp != null && tmp.length() > 0) {
					_attachments.setText(tmp + "; " + path);
				} else {
					_attachments.setText(path);
				}
	        }
	    }
	}


	class FaxOptionsAction extends ClearAction {

	    FaxOptionsAction() {
	        super("fax-options");
	    }

	    public void actionPerformed(ActionEvent e) {
	        if (_options_form == null) {
	            _options_form = new FaxOptionsForm(_options);
	        }

		_options_form.showDialog((Component)e.getSource());
	    }
	}


	protected JTextArea getTextArea () {
		return _body;
	}


	/**
	 * Fetch the list of actions supported by this
	 * text area.  It is implemented to return the list
	 * of actions supported by the embedded JTextArea
	 * augmented with the actions defined locally.
	 */
	protected Action [] getActions() {
	    return TextAction.augmentList(
		getTextArea().getActions(), defaultActions);
	}

	/**
	 * Get the <code>Action</code> for the specified action name.
	 */
	protected Action getAction(String cmd) {
	    return (Action) _commands.get(cmd);
	}



	public void focusGained (FocusEvent e) {
	}


	public void focusLost (FocusEvent e) {
	
		Object source = e.getSource();
		if (source == _subject) {
			String old_value = _subject_value;
			_subject_value = ((JTextField)source).getText();

			if (old_value == null && _subject_value == null) {
				return;
			}

			if (old_value == null || _subject_value == null ||
				old_value.equals(_subject_value)) {
					return;
			}

			firePropertyChange(
				"Subject", old_value, _subject_value);
		} else if (source == _attachments) {
			String old_value = _attachments_value;
			_attachments_value = ((JTextField)source).getText();

			if (old_value == null && _attachments_value == null) {
				return;
			} 

			if (old_value == null || _attachments_value == null ||
				old_value.equals(_attachments_value)) {
					return;
			}

			firePropertyChange(
				"Attachments", old_value, _attachments_value);

		} else if (source == _body) {
			String old_value = _body_value;
			_body_value = getBody();

			if (old_value == null && _body_value == null) {
				return;
			}

			if (old_value == null || _body_value == null ||
				old_value.equals(_body_value)) {
					return;
			}

			firePropertyChange("Body", old_value, _body_value);
		}
	}



	protected JDialog createDialog (Component parent) {

		if (_dialog != null) {
			return (_dialog);
		}

		Font f = getFont();
		Color fg = getForeground();
		Color bg = getBackground();

		_dialog = new JDialog(
			GuiUtils.getFrame(parent), "Quick Fax", true);

		java.awt.Image icon;
		if (parent != null) {
			icon = GuiUtils.getFrame(parent).getIconImage();
		} else {
			java.net.URL url = getClass().getResource(
				"images/vsi16.gif");
			if (url == null) {
				url = getClass().getResource(
					"com/vsi/xmlf/beans/images/vsi16.gif");
			}
	
			ImageIcon iicon = new ImageIcon(url);
			icon = iicon.getImage();
		}
		GuiUtils.getFrame(_dialog).setIconImage(icon);

		JPanel button_panel = new JPanel();
		button_panel.setBackground(bg);
		button_panel.setLayout (new FlowLayout(FlowLayout.RIGHT));
		JButton cancel = new JButton("Cancel");
		cancel.setBackground(bg);
		cancel.setForeground(fg);
		cancel.setFont(f);
		cancel.addActionListener(new CancelAction());
		button_panel.add(cancel);

		JButton ok = new JButton("OK");
		ok.setBackground(bg);
		ok.setForeground(fg);
		ok.setFont(f);
		ok.addActionListener(new OkAction());
		button_panel.add(ok);
		_dialog.getRootPane().setDefaultButton(ok);

		add(button_panel, BorderLayout.SOUTH);
		_dialog.getContentPane().add(this);
		_dialog.pack();

		_dialog.addWindowListener(new AppCloser());

		return (_dialog);
	}


	public void showDialog (Component parent) {
		createDialog(parent);
		GuiUtils.centerDialog(_dialog, parent);
		_dialog.show();
	}


	class CancelAction implements ActionListener {

		CancelAction () {
		}

	        public void actionPerformed(ActionEvent e) {
			_dialog.setVisible(false);
			System.exit(1);
	        }
	}


	class OkAction implements ActionListener {

		OkAction () {
		}

		public void actionPerformed(ActionEvent e) {
			_dialog.setVisible(false);
			submit();
	        }
	}


	class AppCloser extends WindowAdapter {

        	public void windowClosing(WindowEvent e) {
                	System.exit(0);
        	}
	}


	public String getLookAndFeel () {
		return (GuiUtils.getLookAndFeel());
	}


	public void setLookAndFeel (String plaf_name) {

		try {
			GuiUtils.setLookAndFeel(plaf_name, this);
		} catch (Exception ignore) {
		}
	}
}

