package com.vsi.xmlf;

/**
 * This class defines the event that will occur when a response
 * is recieved from the server.
 *
 */
public class ResponseEvent extends java.util.EventObject {

	protected Response _rsp = null;


	/*
	 * Constructor for a response event.
	 *
	 * @param  source  The source of the event.
	 * @param  rsp     The response from the server.
	 */
	public ResponseEvent (Object source, Response rsp) {
		super(source);
		_rsp = rsp;
	}


	/**
	 * Gets the <code>Response</code> object for the event.
	 *
	 * @return the <code>Response</code> object for the event
	 */
	public Response getResponse () {
		return (_rsp);
	}
}
