package com.vsi.xmlf;

/**
 *
 *
 */
public
class ReportType {


	public static final ReportType SHORT = new ReportType("short");
	public static final ReportType FULL  = new ReportType("full");

	private String _value = null;

	/**
	 * Constructors are private since this class is for constants only.
	 */
	private ReportType () {
	}

	private ReportType (String value) {
		_value = value;
	}


	/**
	 * Gets a string representation of this object.
	 *
	 * @return  the String representation of this object
	 */
	public String toString () {
		return (_value);
	}


	/**
	 * Given a report-type string return the corresponding 
	 * <code>ReportType</code> object.
	 *
	 * @returns  The <code>ReportType</code> object corresponding the the 
	 * given string.
	 */
	public static ReportType stringToObject (String str) {

		if (str == null) {
			return (null);
		}

		if (str.equalsIgnoreCase("short")) {
			return (SHORT);
		} else if (str.equalsIgnoreCase("full")) {
			return (FULL);
		} else {
			return (null);
		}
	}
}

