package com.vsi.xmlf;

/**
 * This class encapsulates a XMLF body element composed of
 * inline text.
 *
 */
public 
class InlineBody extends Body {


	protected String _text = null;
	protected String _filename = "inline.txt";


	/**
	 * No args constructor.
	 */
	public InlineBody () {
	}


	/**
	 * Constructs an <code>InlineBody</code> object with the specified text.
	 *
	 * @param  text  the text for this <code>InlineBody</code> object.
	 */
	public InlineBody (String text) {
		_text = text;
	}


	/**
	 * This constructor creates a <code>InlineBody</code> object
	 * from the passed in XML element.
	 *
	 * @param  the XML to use in constructing the object
	 */
	public InlineBody (XmlElement body_element) {
		setFromXml(body_element);
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  body_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement body_element) {

		if (body_element == null) {
			setFilename(null);
			setContentType(null);
			setContentTransferEncoding(null);
			setText(null);
			return;
		}

		setFilename(body_element.getAttribute("filename"));
		setContentType(body_element.getAttribute("content-type"));
		setContentTransferEncoding(body_element.getAttribute(
			"content-transfer-encoding"));
		setText(body_element.getData());
	}


	/**
	 * Gets the data for the body.<p>
	 *
	 * <B>NOTE:</B> All sub-classes of <code>Body</code> must implement
	 * this method.
	 */
	public String getData () {
		return (_text);
	}


	/**
	 * Gets the file name assigned to this InlineBody object.<p>
	 *
	 * <B>NOTE:</B> All sub-classes of <code>Body</code> must implement
	 * this method.
	 */
	public String getFilename () {
		return (_filename);
	}


	/**
	 * Sets the value for the filename to be used for the inline body.
	 *
	 * @param  filename  the filename to use.
	 */
	public void setFilename (String filename) {
		_filename = filename;
	}


	/**
	 * Gets the value for the inline body text.
	 */
	public String getText () {
		return (_text);
	}


	/**
	 * Sets the voice number assigned to this VoiceNumber object.
	 *
	 * @param  number  value for the voice number
	 */
	public void setText (String text) {
		_text = text;
	}
}
