package com.vsi.xmlf;

/**
 * This class encapsulates a XML-F attempt result element.
 *
 */
public
class AttemptResult implements XmlfObject {

	protected String _short_msg = null;
	protected String _long_msg  = null;
	protected Disposition _disposition = null;

	protected String _tag = "result";


	/**
	 * No args constructor.
	 */
	public AttemptResult () {
	}


	/**
	 * Create and initialize an AttemptResult object.
	 * 
	 * @param  short_msg  the short message value
	 * @param  long_msg  the new long message value
	 * @param  disposition  the new value for the disposition
	 */
	public AttemptResult (String short_msg, String long_msg,
		Disposition disposition) {

		_short_msg   = short_msg;
		_long_msg    = long_msg;
		_disposition = disposition;
	}


	/**
	 * Creates an AttemptResult object initialized with the data from 
	 * result_element.
	 *
	 * @param  result_element  the XML element containing the 
	 * attempt result info
	 */
	public AttemptResult (XmlElement result_element) {
		setFromXml(result_element);
	}


	/**
	 * Gets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface. The tag is
         * utilized in the toXml() method.
	 *
	 * @return  the tag for this XML object
	 * @see     #setTag
	 * @see     #toXml
	 */
	public synchronized String getTag () {
		return (_tag);
	}


	/**
	 * Sets the XML tag for this object. This method is implemented by
         * all classes implementing the XmlfObject interface.
         *
         * @param  tag  the XML tag name for this object
	 * @see    #getTag
	 */
	public synchronized void setTag (String tag) {
		_tag = tag;
	}


	/**
	 * Gets a string containing the XML for this object. Use
	 * <code>toXml(String indent)</code> to output indented XML.
	 *
	 * @return  a String containing the XML for this object
	 * @see     #toXml(String indent)
	 */
	public String toXml () {
		return (toXml(""));
	}


	/**
	 * Gets a string containing the indented XML for this object. Use
	 * <code>toXml()</code> to output non-formatted XML.
	 *
	 * @return  a String containing the indented XML for this object
	 * @see     #toXml()
	 */
	public String toXml (String indent) {

		StringBuffer xml = new StringBuffer();

		if (indent == null)
			indent = "";

		xml.append(indent + "<" + getTag());

		if (getDisposition() != null) {
			xml.append(" disposition=\"" + getDisposition() + "\"");
		}
		xml.append(">\n");

		if (getShortMessage() != null) {
			xml.append(indent + "\t<short-message>" + 
				getShortMessage() + "</short-message>\n");
		}

		if (getLongMessage() != null) {
			xml.append(indent + "\t<long-message>" +
				getLongMessage() + "</long-message>\n");
		}

		xml.append(indent + "</" + getTag() + ">\n");
		return (xml.toString());
	}


	/**
	 * Assignes the values/attributes in the XML data to this object.
	 *
	 * @param  result_element  the XML data to assign from
	 */
	public void setFromXml (XmlElement result_element) {

		setShortMessage(null);
		setLongMessage(null);
		setDisposition(null);

		if (result_element == null) {
			return;
		}


		setDisposition(Disposition.stringToObject(
			result_element.getAttribute("disposition")));

		XmlElement xml[] = result_element.getSubElements();

		setShortMessage(XmlElement.getData(xml, "short-message"));
		setLongMessage(XmlElement.getData(xml, "long-message"));
	}


	/**
	 * Gets the short-message string assigned to the AttemptResult object.
	 */
	public synchronized String getShortMessage () {
		return (_short_msg);
	}


	/**
	 * Gets the long-message assigned to the AttemptResult object.
	 */
	public synchronized String getLongMessage () {
		return (_long_msg);
	}


	/**
	 * Gets the Disposition object contained by this object.
	 *
	 * @return  the contained Disposition object.
	 */
	public synchronized Disposition getDisposition () {
		return (_disposition);
	}



	/**
	 * Sets the short message for this attempt-result element.
	 *
	 * @param  short_msg  the short message value
	 */
	public synchronized void setShortMessage (String short_msg) {
		_short_msg = short_msg;
	}


	/**
	 * Sets the long message for this attempt-result element.
	 *
	 * @param  long_msg  the new long message value
	 */
	public synchronized void setLongMessage (String long_msg) {
		_long_msg = long_msg;
	}


	/**
	 * Sets the disposition for this attempt-result element.
	 *
	 * @param  disposition  the new value for the disposition
	 */
	public synchronized void setDisposition (Disposition disposition) {
		_disposition = disposition;
	}
}

